define("tiny_autosave/options",["exports","./common","editor_tiny/options","editor_tiny/utils"],(function(_exports,_common,_options,_utils){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.getBackoffTime=void 0,Object.defineProperty(_exports,"getContextId",{enumerable:!0,get:function(){return _options.getContextId}}),Object.defineProperty(_exports,"getDraftItemId",{enumerable:!0,get:function(){return _options.getDraftItemId}}),_exports.setAutosaveHasReset=_exports.register=_exports.markInitialised=_exports.isInitialised=_exports.hasAutosaveHasReset=_exports.getPageInstance=_exports.getPageHash=void 0;
/**
   * Options helper for the Moodle Tiny Autosave plugin.
   *
   * @module      tiny_autosave/options
   * @copyright   2022 Andrew Lyons <andrew@nicols.co.uk>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const initialisedOptionName=(0,_options.getPluginOptionName)(_common.pluginName,"initialised"),pageHashName=(0,_options.getPluginOptionName)(_common.pluginName,"pagehash"),pageInstanceName=(0,_options.getPluginOptionName)(_common.pluginName,"pageinstance"),backoffTime=(0,_options.getPluginOptionName)(_common.pluginName,"backoffTime"),autosaveHasReset=(0,_options.getPluginOptionName)(_common.pluginName,"autosaveHasReset");_exports.register=editor=>{const registerOption=editor.options.register;registerOption(initialisedOptionName,{processor:"boolean",default:!1}),registerOption(pageHashName,{processor:"string",default:""}),registerOption(pageInstanceName,{processor:"string",default:""}),registerOption(pageInstanceName,{processor:"string",default:""}),registerOption(backoffTime,{processor:"number",default:500}),registerOption(autosaveHasReset,{processor:"boolean",default:!1})};_exports.isInitialised=editor=>!!(0,_utils.ensureEditorIsValid)(editor)&&editor.options.get(initialisedOptionName);_exports.markInitialised=editor=>editor.options.set(initialisedOptionName,!0);_exports.getPageHash=editor=>editor.options.get(pageHashName);_exports.getPageInstance=editor=>editor.options.get(pageInstanceName);_exports.getBackoffTime=editor=>editor.options.get(backoffTime);_exports.setAutosaveHasReset=editor=>editor.options.set(autosaveHasReset,!0);_exports.hasAutosaveHasReset=editor=>editor.options.get(autosaveHasReset)}));

//# sourceMappingURL=options.min.js.map