<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Matricula extends Model
{
    use HasFactory;

    protected $table = 'matriculas';
    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id';
    protected $fillable = [
        'codigo_matricula',
        'postulante_id',
        'plan_estudio_id',
        'periodo_id',
        'semestre_id',
        'estado',
        'fecha_matricula',
    ];

    protected $dates = [
        'fecha_matricula', // Asegúrate de que este campo sea tratado como una fecha
    ];

    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id', 'id_postulante');
    }

    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id');
    }

    public function periodo()
    {
        return $this->belongsTo(Periodo::class, 'periodo_id');
    }

    public function semestre()
    {
        return $this->belongsTo(Semestre::class, 'semestre_id');
    }

    public function matriculaCursos()
    {
        return $this->hasMany(MatriculaCurso::class);
    }
}
