<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfertaLaboral extends Model
{
    use HasFactory;

    protected $table = 'ofertas_laborales';
    protected $primaryKey = 'id_oferta';

    protected $fillable = [
        'titulo',
        'descripcion',
        'fecha_publicacion',
        'fecha_limite',
        'id_tipo_contrato',
        'id_empresa',
        'id_plan_estudio',
        'lugar',
        'tipo_oferta',
        'remuneracion',
        'vacantes',
        'experiencia',
        'pasos_postular',
        'estado',
        'archivo_pdf',
    ];

    // Relación con TipoContrato
    public function tipoContrato()
    {
        return $this->belongsTo(TipoContrato::class, 'id_tipo_contrato');
    }

    // Relación con Empresa
    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'id_empresa');
    }

    // Relación con PlanEstudio
    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'id_plan_estudio');
    }
    // OfertaLaboral.php
    public function postulaciones()
    {
        return $this->hasMany(Postulacion::class, 'id_oferta');
    }

}
