@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Caja @endslot
@slot('title') Caja @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalTransaccion">
                    <i class="fas fa-plus"></i> Nueva Transacción
                </button>

                
                <div class="table-responsive">
                    
                    <table id="tablaSemestres" class="table table-striped mb-0 table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Fecha</th>
                                <th>Tipo</th>
                                <th>Concepto</th>
                                <th>Monto (S/)</th>
                                <th>Estado</th>
                                <th>Caja</th>
                                <th>DNI</th>
                                <th>Apellidos y Nombres</th>
                                <th class="text-end">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($transacciones as $t)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $t->fecha }}</td>
                                    <td>
                                        <span class="badge {{ $t->tipo == 'ingreso' ? 'bg-success' : 'bg-info' }}">
                                            {{ ucfirst($t->tipo) }}
                                        </span>
                                    </td>
                                    <td>{{ $t->concepto->nombre ?? '-' }}</td>
                                    <td>S/ {{ number_format($t->monto, 2) }}</td>
                                    <td>
                                        <span class="badge {{ $t->estado == 'aceptado' ? 'bg-primary' : 'bg-danger' }}">
                                            {{ ucfirst($t->estado) }}
                                        </span>
                                    </td>
                                    <td>{{ $t->caja->nombre ?? '-' }}</td>
                                    <td>{{ $t->dni ?? '-' }}</td>
                                    <td>{{ $t->apellidos }} {{ $t->nombres }}</td>
                                    <td class="text-end">
                                        
                                        
                                        <button onclick="anularTransaccion({{ $t->id_transaccion }})" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-x-circle"></i>
                                        </button>


                                        <a href="{{ route('transacciones.pdf', $t->id_transaccion) }}" class="btn btn-sm btn-outline-info" target="_blank">
                                            <i class="bi bi-printer"></i>
                                        </a>

                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center text-muted">No hay transacciones registradas.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal Nueva Transacción -->
<div class="modal fade" id="modalTransaccion" tabindex="-1" aria-labelledby="modalTransaccionLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content border-0 shadow-lg rounded-4">
            <div class="modal-header bg-de-primary text-white rounded-top-4">
                <h5 class="modal-title">
                    <i class="fas fa-plus-circle me-2"></i> Registrar Nueva Transacción
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <form id="formNuevaTransaccion">
                <div class="modal-body px-4 py-3">
                    <!-- Sección 1: Información de transacción -->
                    <h6 class="text-muted mb-3 border-bottom pb-1">
                        <i class="bi bi-wallet2 me-1 text-primary"></i> Datos de la Transacción
                    </h6>
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <label class="form-label">Caja <span class="text-danger">*</span></label>
                            <select name="caja_id" class="form-select" required>
                                <option value="">Seleccione una caja...</option>
                                @foreach($cajas as $caja)
                                    <option value="{{ $caja->id_caja }}">
                                        {{ $caja->nombre }} ({{ date('d/m/Y', strtotime($caja->fecha_apertura)) }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Tipo <span class="text-danger">*</span></label>
                            <select name="tipo" class="form-select" required>
                                <option value="">Seleccione...</option>
                                <option value="ingreso">Ingreso</option>
                                <option value="egreso">Egreso</option>
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Fecha <span class="text-danger">*</span></label>
                            <input type="date" name="fecha" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Concepto <span class="text-danger">*</span></label>
                            <select name="concepto_id" class="form-select" id="selectConcepto" required>
                                <option value="">Seleccione...</option>
                                @foreach($conceptos as $concepto)
                                    <option value="{{ $concepto->id_concepto }}" data-precio="{{ $concepto->precio }}">
                                        {{ $concepto->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Monto (S/.) <span class="text-danger">*</span></label>
                            <input type="number" name="monto" class="form-control" min="0" step="0.01" placeholder="0.00" required>
                        </div>
                    </div>

                    <!-- Sección 2: Datos del Cliente (opcional) -->
                    <h6 class="text-muted mb-3 border-bottom pb-1">
                        <i class="bi bi-person-badge me-1 text-secondary"></i> Datos del Cliente
                    </h6>
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label class="form-label">DNI</label>
                            <input type="text" name="dni" class="form-control" maxlength="15" placeholder="Opcional">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Nombres</label>
                            <input type="text" name="nombres" class="form-control" maxlength="30" placeholder="Opcional">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Apellidos</label>
                            <input type="text" name="apellidos" class="form-control" maxlength="30" placeholder="Opcional">
                        </div>
                    </div>

                    <!-- Observación -->
                    <div class="mb-3">
                        <label class="form-label">Observación</label>
                        <textarea name="observacion" class="form-control" rows="2" placeholder="Detalles adicionales (opcional)"></textarea>
                    </div>
                </div>

                <div class="modal-footer bg-light rounded-bottom-4 px-4 py-2">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-1"></i> Cancelar
                    </button>
                    <button type="submit" class="btn btn-de-primary">
                        <i class="bi bi-save me-1"></i> Guardar Transacción
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>





@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaSemestres").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaSemestres_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    // Autocompletar monto al elegir concepto
    document.getElementById('selectConcepto').addEventListener('change', function () {
        const selected = this.options[this.selectedIndex];
        const precio = selected.getAttribute('data-precio');
        if (precio) {
            document.querySelector('input[name="monto"]').value = precio;
        }
    });
</script>
<!-- agregar -->
<script>
    document.getElementById('formNuevaTransaccion').addEventListener('submit', function(e) {
        e.preventDefault();

        const form = this;
        const formData = new FormData(form);

        fetch("{{ route('transacciones.store') }}", {
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: '¡Transacción registrada!',
                    timer: 1500,
                    showConfirmButton: false
                }).then(() => {
                    form.reset();
                    const modal = bootstrap.Modal.getInstance(document.getElementById('modalTransaccion'));
                    modal.hide();
                    location.reload(); // Opcional: recargar para ver en la tabla
                });
            } else {
                Swal.fire('Error', data.message || 'No se pudo registrar la transacción.', 'error');
            }
        })
        .catch(() => {
            Swal.fire('Error', 'Error del servidor. Intenta nuevamente.', 'error');
        });
    });
</script>
<!-- anular -->
<script>
function anularTransaccion(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "Esta acción anulará la transacción.",
        icon: 'warning',
        input: 'text',
        inputLabel: 'Motivo de anulación',
        inputPlaceholder: 'Escribe el motivo...',
        inputValidator: (value) => {
            if (!value) {
                return 'Debes ingresar un motivo';
            }
        },
        showCancelButton: true,
        confirmButtonText: 'Sí, anular',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/transacciones/${id}/anular`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ motivo: result.value })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('Anulada', data.message, 'success')
                        .then(() => location.reload());
                } else {
                    Swal.fire('Error', data.message, 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error', 'Error de servidor', 'error');
            });
        }
    });
}
</script>

@endsection
