@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Turnos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevaTurno">
                    <i class="fas fa-plus"></i> Agregar Nuevo Turno
                </button>
                <div class="table-responsive">
                <table id="tablaTurno" class="table table-striped mb-0 table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Nombre</th>
                            <th>Hora de Inicio</th>
                            <th>Hora de Fin</th>
                            <th class="text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($turnos as $turno)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $turno->nombre }}</td>
                                <td>{{ $turno->hora_inicio }}</td>
                                <td>{{ $turno->hora_fin }}</td>
                                <td class="text-center">
                                    <a href="#" class="text-warning"
                                    data-bs-toggle="modal"
                                    data-bs-target="#modalEditarTurno"
                                    data-id="{{ $turno->id }}"
                                    data-nombre="{{ $turno->nombre }}"
                                    data-hora_inicio="{{ $turno->hora_inicio }}"
                                    data-hora_fin="{{ $turno->hora_fin }}">
                                    <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <a href="#" class="text-danger btn-eliminar-turno" data-id="{{ $turno->id }}">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal para agregar nuevo turno -->
<div class="modal fade" id="modalNuevaTurno" tabindex="-1" aria-labelledby="modalNuevaTurnoLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevaTurnoLabel">Agregar Nuevo Turno</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formNuevoTurno">
                    @csrf
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre del Turno</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="hora_inicio" class="form-label">Hora de Inicio</label>
                        <input type="time" class="form-control" id="hora_inicio" name="hora_inicio" required>
                    </div>
                    <div class="mb-3">
                        <label for="hora_fin" class="form-label">Hora de Fin</label>
                        <input type="time" class="form-control" id="hora_fin" name="hora_fin" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnGuardarTurno">Guardar Turno</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal para editar turno -->
<div class="modal fade" id="modalEditarTurno" tabindex="-1" aria-labelledby="modalEditarTurnoLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarTurnoLabel">Editar Turno</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formEditarTurno">
                    @csrf
                    <input type="hidden" id="edit_turno_id" name="id">
                    <div class="mb-3">
                        <label for="edit_nombre" class="form-label">Nombre del Turno</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_hora_inicio" class="form-label">Hora de Inicio</label>
                        <input type="time" class="form-control" id="edit_hora_inicio" name="hora_inicio" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_hora_fin" class="form-label">Hora de Fin</label>
                        <input type="time" class="form-control" id="edit_hora_fin" name="hora_fin" required>
                    </div>
                    
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnActualizarTurno">Actualizar Turno</button>
            </div>
        </div>
    </div>
</div>



<!-- Modal de Edición -->





<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaTurno").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaTurno_wrapper .col-md-6:eq(0)');
    });
</script>

    <!-- Script para AJAX y SweetAlert -->
<script>
    $(document).ready(function() {
        // Guardar turno
        $('#btnGuardarTurno').click(function() {
            // Recoger datos del formulario
            var nombre = $('#nombre').val();
            var hora_inicio = $('#hora_inicio').val();
            var hora_fin = $('#hora_fin').val();
            
            // Validar campos
            if (nombre && hora_inicio && hora_fin) {
                $.ajax({
                    url: '{{ route('turnos.store') }}',  // Ruta para guardar el turno
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        nombre: nombre,
                        hora_inicio: hora_inicio,
                        hora_fin: hora_fin,
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: '¡Turno guardado!',
                                text: response.message,
                                confirmButtonText: 'Aceptar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    // Cerrar el modal
                                    $('#modalNuevaTurno').modal('hide');
                                    // Limpiar el formulario
                                    $('#formNuevoTurno')[0].reset();
                                    // Recargar o actualizar la lista de turnos (puedes hacerlo aquí según tu preferencia)
                                    location.reload();  // Esto recarga la página, lo puedes ajustar a tu necesidad
                                }
                            });
                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un error al guardar el turno.',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campos incompletos',
                    text: 'Por favor, completa todos los campos.',
                    confirmButtonText: 'Aceptar'
                });
            }
        });
    });
</script>

<!-- Script para cargar datos en el modal y actualizar -->
<script>
    $(document).on('click', '.text-warning', function() {
        var turno_id = $(this).data('id');
        var nombre = $(this).data('nombre');
        var hora_inicio = $(this).data('hora_inicio');
        var hora_fin = $(this).data('hora_fin');
        
        // Llenamos el formulario con los valores actuales
        $('#edit_turno_id').val(turno_id);
        $('#edit_nombre').val(nombre);
        $('#edit_hora_inicio').val(hora_inicio);
        $('#edit_hora_fin').val(hora_fin);
    });

    // Actualizar turno
    $('#btnActualizarTurno').click(function() {
        var turno_id = $('#edit_turno_id').val();
        var nombre = $('#edit_nombre').val();
        var hora_inicio = $('#edit_hora_inicio').val();
        var hora_fin = $('#edit_hora_fin').val();
        var descripcion = $('#edit_descripcion').val();
        
        if (nombre && hora_inicio && hora_fin) {
            $.ajax({
                url: '/turnos/' + turno_id,  // Ruta para actualizar el turno
                type: 'PUT',
                data: {
                    _token: '{{ csrf_token() }}',
                    nombre: nombre,
                    hora_inicio: hora_inicio,
                    hora_fin: hora_fin,
                    descripcion: descripcion,
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Turno actualizado!',
                            text: response.message,
                            confirmButtonText: 'Aceptar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $('#modalEditarTurno').modal('hide');
                                // Recargar o actualizar la lista de turnos
                                location.reload();  // Esto recarga la página, puedes ajustarlo
                            }
                        });
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Hubo un error al actualizar el turno.',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        } else {
            Swal.fire({
                icon: 'warning',
                title: 'Campos incompletos',
                text: 'Por favor, completa todos los campos.',
                confirmButtonText: 'Aceptar'
            });
        }
    });
</script>

<script>
    $(document).on('click', '.btn-eliminar-turno', function(e) {
        e.preventDefault(); // Prevenir la acción por defecto del enlace

        var turnoId = $(this).data('id'); // Obtener el ID del turno

        // Mostrar SweetAlert de confirmación
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Este cambio no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminarlo',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Realizar la solicitud AJAX para eliminar el turno
                $.ajax({
                    url: '/turnos/' + turnoId,  // Ruta para eliminar el turno
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}',  // Agregar el token CSRF para la seguridad
                    },
                    success: function(response) {
                        if (response.success) {
                            // Mostrar mensaje de éxito con SweetAlert
                            Swal.fire(
                                '¡Eliminado!',
                                'El turno ha sido eliminado correctamente.',
                                'success'
                            ).then(function() {
                                // Recargar la página o eliminar el elemento de la tabla
                                location.reload(); // Recarga la página para actualizar la lista
                            });
                        } else {
                            // Mostrar mensaje de error con SweetAlert
                            Swal.fire(
                                'Error',
                                'Hubo un problema al eliminar el turno.',
                                'error'
                            );
                        }
                    },
                    error: function() {
                        // Si ocurre algún error en la solicitud AJAX
                        Swal.fire(
                            'Error',
                            'Hubo un error al procesar la solicitud.',
                            'error'
                        );
                    }
                });
            }
        });
    });

</script>


@endsection
