<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Periodos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalCrearOferta">
                    <i class="fas fa-plus"></i> Agregar Nueva Oferta 
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead >
                            <tr>
                                <th>#</th>
                                <th>Título</th>
                                <th>Empresa</th>
                                <th>Contrato</th>
                                <th>Plan</th>
                                <th>Publicación</th>
                                <th>Fecha Fin</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $ofertas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $oferta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i + 1); ?></td>
                                <td><?php echo e($oferta->titulo); ?></td>
                                <td><?php echo e($oferta->empresa->nombre_empresa ?? '-'); ?></td>
                                <td><?php echo e($oferta->tipoContrato->nombre_tipo_contrato ?? '-'); ?></td>
                                <td><?php echo e($oferta->planEstudio->nombre ?? '-'); ?></td>
                                <td><?php echo e($oferta->fecha_publicacion); ?></td>
                                <td><?php echo e($oferta->fecha_limite); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($oferta->estado == 'aceptado' ? 'success' : ($oferta->estado == 'pendiente' ? 'warning' : 'danger')); ?>">
                                        <?php echo e(ucfirst($oferta->estado)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('ofertas.laborales.pdf', $oferta->id_oferta)); ?>" 
                                        target="_blank" 
                                        class="btn btn-sm btn-primary" 
                                        title="Ver oferta como PDF">
                                            <i class="las la-eye"></i>
                                    </a>


                                    <button class="btn btn-sm btn-info text-white editar-btn" title="Editar" data-id="<?php echo e($oferta->id_oferta); ?>">
                                        <i class="las la-pen"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger eliminar-btn" title="Eliminar" data-id="<?php echo e($oferta->id_oferta); ?>">
                                        <i class="las la-trash-alt"></i>
                                    </button>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<?php echo $__env->make('ofertas_laborales.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <!-- Aquí iría el modal crear/editar -->




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', () => {

        // Eliminar oferta
        document.querySelectorAll('.eliminar-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const id = btn.dataset.id;

                Swal.fire({
                    title: '¿Eliminar?',
                    text: 'Esta acción no se puede deshacer.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar',
                }).then(result => {
                    if (result.isConfirmed) {
                        fetch(`/ofertas-laborales/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                                'X-Requested-With': 'XMLHttpRequest',
                            }
                        })
                        .then(res => res.json())
                        .then(data => {
                            Swal.fire('Eliminado', data.message, 'success');
                            setTimeout(() => location.reload(), 1000);
                        })
                        .catch(() => {
                            Swal.fire('Error', 'No se pudo eliminar.', 'error');
                        });
                    }
                });
            });
        });

        // Editar oferta (cargar datos al modal)
        document.querySelectorAll('.editar-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                const id = btn.dataset.id;
                fetch(`/ofertas-laborales/${id}`)
                    .then(res => res.json())
                    .then(data => {
                        const form = document.getElementById('formEditarOferta');
                        form.action = `/ofertas-laborales/${id}`;
                        form.querySelector('[name=titulo]').value = data.titulo;
                        form.querySelector('[name=descripcion]').value = data.descripcion;
                        form.querySelector('[name=fecha_publicacion]').value = data.fecha_publicacion;
                        form.querySelector('[name=fecha_limite]').value = data.fecha_limite;
                        form.querySelector('[name=id_tipo_contrato]').value = data.id_tipo_contrato;
                        form.querySelector('[name=id_empresa]').value = data.id_empresa;
                        form.querySelector('[name=id_plan_estudio]').value = data.id_plan_estudio;
                        form.querySelector('[name=lugar]').value = data.lugar;
                        form.querySelector('[name=tipo_oferta]').value = data.tipo_oferta;
                        form.querySelector('[name=remuneracion]').value = data.remuneracion;
                        form.querySelector('[name=vacantes]').value = data.vacantes;
                        form.querySelector('[name=experiencia]').value = data.experiencia;
                        form.querySelector('[name=pasos_postular]').value = data.pasos_postular;
                        form.querySelector('[name=estado]').value = data.estado;

                        const pdfLabel = document.getElementById('pdf_actual');
                        pdfLabel.innerHTML = data.archivo_pdf 
                            ? `<a href="/ofertas_pdf/${data.archivo_pdf}" target="_blank">Ver archivo actual</a>` 
                            : 'Sin archivo.';

                        new bootstrap.Modal(document.getElementById('modalEditarOferta')).show();
                    });
            });
        });

        // Enviar formulario de edición vía AJAX (usando _method PUT)
        const formEditar = document.getElementById('formEditarOferta');
        formEditar.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(formEditar);
            formData.append('_method', 'PUT'); // Importante para Laravel

            const actionUrl = formEditar.action;

            fetch(actionUrl, {
                method: 'POST', // Laravel tratará esto como PUT por el _method
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                Swal.fire('Actualizado', data.message, 'success');
                document.getElementById('modalEditarOferta').querySelector('.btn-close').click();
                setTimeout(() => location.reload(), 1000);
            })
            .catch(() => {
                Swal.fire('Error', 'No se pudo actualizar la oferta.', 'error');
            });
        });
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', () => {
        const formCrear = document.getElementById('formCrearOferta');

        formCrear.addEventListener('submit', function(e) {
            e.preventDefault(); // evitar envío tradicional

            const formData = new FormData(this);

            fetch(this.action, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>', // o incluirlo en meta tag y leerlo
                'X-Requested-With': 'XMLHttpRequest',
            },
            body: formData
            })
            .then(async res => {
            if (!res.ok) {
                // Manejar errores HTTP
                const errorData = await res.json();
                throw new Error(errorData.message || 'Error al guardar');
            }
            return res.json();
            })
            .then(data => {
            Swal.fire('Guardado', data.message || 'Oferta creada con éxito', 'success');
            // Cerrar modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalCrearOferta'));
            modal.hide();

            // Limpiar formulario
            formCrear.reset();

            // Opcional: recargar tabla/lista o actualizar vista
            setTimeout(() => location.reload(), 1000);
            })
            .catch(err => {
            Swal.fire('Error', err.message || 'No se pudo guardar', 'error');
            });
        });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/ofertas_laborales/index.blade.php ENDPATH**/ ?>