<div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <strong>Filtrar Cursos</strong>
    </div>
    <div class="card-body">
        <form id="filtro-form">
            <div class="row align-items-end g-2">
                <div class="col-md-3">
                    <label for="periodo_id" class="form-label mb-0">Periodo</label>
                    <select name="periodo_id" id="periodo_id" class="form-select form-select-sm" required>
                        <option value="">Seleccione un periodo</option>
                        <?php $__currentLoopData = \App\Models\Periodo::orderByDesc('fecha_inicio')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($periodo->id); ?>"><?php echo e($periodo->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <label for="plan_estudio_id" class="form-label mb-0">Plan de estudio</label>
                    <select name="plan_estudio_id" id="plan_estudio_id" class="form-select form-select-sm" required disabled>
                        <option value="">Seleccione un plan</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <label for="semestre_id" class="form-label mb-0">Semestre</label>
                    <select name="semestre_id" id="semestre_id" class="form-select form-select-sm" required disabled>
                        <option value="">Seleccione un semestre</option>
                    </select>
                </div>

                <div class="col-md-3 d-grid">
                    <button type="submit" class="btn btn-success btn-sm">
                        <i class="fas fa-filter me-1"></i> Filtrar
                    </button>
                </div>
            </div>
        </form>

    </div>
</div>


<div id="contenedor-cursos-filtrados">
    <?php if(count($cursosAgrupados)): ?>
        <?php echo $__env->make('roles.partials.cursos_docente', ['cursosAgrupados' => $cursosAgrupados], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function () {
    // Cargar planes al seleccionar un periodo
    $('#periodo_id').on('change', function () {
        const periodoId = $(this).val();

        $('#plan_estudio_id').prop('disabled', true).html('<option>-- Cargando --</option>');
        $('#semestre_id').prop('disabled', true).html('<option value="">Seleccione un semestre</option>');

        if (periodoId) {
            $.get(`/docente/planes/${periodoId}`, function (planes) {
                let opciones = '<option value="">Seleccione un plan</option>';
                planes.forEach(plan => {
                    opciones += `<option value="${plan.id}">${plan.nombre}</option>`;
                });
                $('#plan_estudio_id').html(opciones).prop('disabled', false);

                // Ahora cargamos los semestres sin depender del plan
                $.get(`/docente/semestres`, function (semestres) {
                    let opcionesSem = '<option value="">Seleccione un semestre</option>';
                    semestres.forEach(sem => {
                        opcionesSem += `<option value="${sem.id}">${sem.nombre}</option>`;
                    });
                    $('#semestre_id').html(opcionesSem).prop('disabled', false);
                });
            });
        } else {
            $('#plan_estudio_id').html('<option value="">Seleccione un plan</option>').prop('disabled', true);
            $('#semestre_id').html('<option value="">Seleccione un semestre</option>').prop('disabled', true);
        }
    });

    // Filtrar cursos al enviar el formulario
    $('#filtro-form').on('submit', function (e) {
        e.preventDefault();

        const periodoId = $('#periodo_id').val();
        const planId = $('#plan_estudio_id').val();
        const semestreId = $('#semestre_id').val();

        if (periodoId && planId && semestreId) {
            $.ajax({
                url: '/docente/cursos-filtrados',
                method: 'GET',
                data: {
                    periodo_id: periodoId,
                    plan_estudio_id: planId,
                    semestre_id: semestreId
                },
                success: function (html) {
                    $('#contenedor-cursos-filtrados').html(html);
                },
                error: function () {
                    alert('Ocurrió un error al filtrar los cursos.');
                }
            });
        } else {
            alert('Debe seleccionar periodo, plan y semestre.');
        }
    });
});
</script>
<?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/roles/dashboard_docente.blade.php ENDPATH**/ ?>