<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; }
        th { background-color: #f5f5f5; }
        .curso-header { height: 400px; }
        .curso-vertical {
            writing-mode: vertical-rl;
            transform: rotate(270deg);
            white-space: nowrap;
        }
        .ancho-reducido { width: 20px; }
        .columna-estudiante { width: 250px; }
        .columna-dni { width: 100px; }
         .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }
        .logo-img {
            max-height: 60px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" class = "logo-img">
        
    </div>

    <div class="header">
        
        
    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Nombre del IEST/IES/EEST</strong></td>
                <td><?php echo e($instituto['nombre']); ?></td>
                <td><strong>DRE</strong></td>
                <td><?php echo e($instituto['dre']); ?></td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td><?php echo e($instituto['codigo_modular']); ?></td>
                <td><strong>Tipo de Gestión</strong></td>
                <td>Pública</td>
            </tr>
            <tr>
                <td><strong>Departamento</strong></td>
                <td><?php echo e($instituto['departamento']); ?></td>
                <td><strong>Provincia</strong></td>
                <td><?php echo e($instituto['provincia']); ?></td>
            </tr>
            <tr>
                <td><strong>Distrito</strong></td>
                <td><?php echo e($instituto['distrito']); ?></td>
                <td><strong>Modalidad</strong></td>
                <td>Presencial</td>
            </tr>
            <tr>
                <td><strong>Programa de Estudio</strong></td>
                <td><?php echo e($curso_info['carrera']); ?></td>
                <td><strong>Periodo Lectivo</strong></td>
                <td><?php echo e($curso_info['periodo']); ?></td>
            </tr>
            <tr>
                <td><strong>Resolución de Autorización (Tipo, número y fecha)</strong></td>
                <td>OFICIO N° 134-2014-MINEDU</td>
                <td><strong>Resolución de Revalidación (Tipo, número y fecha)</strong></td>
                <td>RD N° 2390-2009-ED</td>
            </tr>
            <tr>
                
                <td><strong>Semestres</strong></td>
                <td><?php echo e($curso_info['semestre']); ?></td>
            </tr>
            
        </tbody>
    </table>
    <div class="container">
        <table>
            <thead>
                <tr>
                    <th class="columna-dni">DNI</th>
                    <th class="columna-estudiante">Apellidos y Nombres</th>
                    <?php $__currentLoopData = $cursos_unicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $curso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th class="curso-header ancho-reducido">
                            <div class="curso-vertical ancho-reducido"><?php echo e($curso); ?></div>
                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th class="curso-header ancho-reducido"><div class="curso-vertical ancho-reducido">Aprobadas</div></th>
                    <th class="curso-header ancho-reducido"><div class="curso-vertical ancho-reducido">Desaprobadas</div></th>
                    <th class="columna-estudiante">Observaciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $datos_estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dni => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($dni); ?></td>
                        <td><?php echo e($info['apellidos']); ?> <?php echo e($info['nombres']); ?></td>
                        <?php $__currentLoopData = $cursos_unicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $curso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $nota = $info['cursos'][$curso] ?? '-';
                                $color = ($nota === '-') ? 'black' : (($nota >= 11) ? 'black' : 'red');
                            ?>
                            <td style="color: <?php echo e($color); ?>"><?php echo e($nota); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($info['aprobados']); ?></td>
                        <td><?php echo e($info['desaprobados']); ?></td>
                        <td>-</td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/reportes/pdf_acta_notas.blade.php ENDPATH**/ ?>