<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Docentes <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoDocente">
                    <i class="fas fa-plus"></i> Agregar Nuevo Docente
                </button>
                <button type="button" class="btn btn-success btn-sm px-4 mt-0 mb-3 ms-2"
                    data-bs-toggle="modal"
                    data-bs-target="#modalImportarDocentes">
                    <i class="fas fa-file-excel"></i> Importación Masiva
                </button>
                <div class="table-responsive">
                    <table id="tablaDocentes" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Nombre Completo</th>
                                <th>DNI</th>
                                <th>Correo</th>
                                <th>Telefono</th>
                                <th>Usuario</th>
                                <th>Roles</th>
                                <th>Area</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $docentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $docente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($docente ->id); ?></td>
                                <td><?php echo e($docente->nombre); ?> <?php echo e($docente->apellido); ?></td>
                                <td><?php echo e($docente->dni); ?></td>
                                <td><?php echo e($docente->email); ?></td>
                                <td><?php echo e($docente->telefono); ?></td>
                                <td><?php echo e($docente->usuario->username ?? 'Sin usuario'); ?></td>
                                <td>
                                    <?php if($docente->usuario && $docente->usuario->roles->isNotEmpty()): ?>
                                        <?php $__currentLoopData = $docente->usuario->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-info text-dark"><?php echo e($rol->nombre); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <span class="badge badge-soft-warning">Sin rol</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($docente->usuario && $docente->usuario->areas->isNotEmpty()): ?>
                                        <?php $__currentLoopData = $docente->usuario->areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-secondary"><?php echo e($area->nombre); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <span class="badge badge-soft-warning">Sin área</span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <!-- Icono de editar -->
                                    <a href="#" class="btn-editar-docente" data-bs-toggle="modal" data-bs-target="#editModal"
                                        data-id="<?php echo e($docente->id); ?>"
                                        data-nombre="<?php echo e($docente->nombre); ?>"
                                        data-apellido="<?php echo e($docente->apellido); ?>"
                                        data-email="<?php echo e($docente->email); ?>"
                                        data-telefono="<?php echo e($docente->telefono); ?>"
                                        data-direccion="<?php echo e($docente->direccion); ?>"
                                        data-departamento="<?php echo e($docente->departamento); ?>"
                                        data-cargo="<?php echo e($docente->cargo); ?>">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>



                                    <!-- Icono de eliminar -->
                                    <a href="#" class="text-danger btn-eliminar-docente" data-id="<?php echo e($docente->id); ?>">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </a>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->

<div class="modal fade" id="modalNuevoDocente" tabindex="-1" aria-labelledby="modalNuevoDocenteLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form id="formNuevoDocente" method="POST" action="<?php echo e(route('docentes.store')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="modalNuevoDocenteLabel">
                        <i class="fas fa-chalkboard-teacher me-2"></i>Registrar Nuevo Docente
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <div class="modal-body row g-3">
                    <div class="col-md-6">
                        <label for="nombre" class="form-label"><i class="fas fa-user"></i> Nombre</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label for="apellido" class="form-label"><i class="fas fa-user-tag"></i> Apellido</label>
                        <input type="text" name="apellido" id="apellido" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label for="dni" class="form-label"><i class="fas fa-id-card"></i> DNI</label>
                        <input type="text" name="dni" id="dni" class="form-control" maxlength="8" required>
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label"><i class="fas fa-envelope"></i> Email</label>
                        <input type="email" name="email" id="email" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label for="telefono" class="form-label"><i class="fas fa-phone"></i> Teléfono</label>
                        <input type="text" name="telefono" id="telefono" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label for="direccion" class="form-label"><i class="fas fa-map-marker-alt"></i> Dirección</label>
                        <input type="text" name="direccion" id="direccion" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label for="departamento" class="form-label"><i class="fas fa-building"></i> Departamento</label>
                        <input type="text" name="departamento" id="departamento" class="form-control">
                    </div>
                    <div class="col-md-6">
                        <label for="cargo" class="form-label"><i class="fas fa-briefcase"></i> Cargo</label>
                        <input type="text" name="cargo" id="cargo" class="form-control">
                    </div>
                    <div class="col-md-12">
                        <label class="form-label"><i class="fas fa-user-shield"></i> Roles del Usuario</label>
                        <div class="row">
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="roles[]" value="<?php echo e($rol->id); ?>" id="rol_<?php echo e($rol->id); ?>">
                                        <label class="form-check-label" for="rol_<?php echo e($rol->id); ?>">
                                            <?php echo e($rol->nombre); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <label class="form-label"><i class="fas fa-layer-group"></i> Áreas del Usuario</label>
                        <div class="row">
                            <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="areas[]" value="<?php echo e($area->id); ?>" id="area_<?php echo e($area->id); ?>">
                                        <label class="form-check-label" for="area_<?php echo e($area->id); ?>">
                                            <?php echo e($area->nombre); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Guardar
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> Cancelar
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Modal -->

<!-- Modal para Editar Docente -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Editar Docente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formEditarDocente" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="container">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label for="edit_nombre" class="form-label">Nombre</label>
                                <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                            </div>
                            <div class="col-md-4">
                                <label for="edit_apellido" class="form-label">Apellido</label>
                                <input type="text" class="form-control" id="edit_apellido" name="apellido" required>
                            </div>
                            <div class="col-md-4">
                                <label for="edit_email" class="form-label">Correo electrónico</label>
                                <input type="email" class="form-control" id="edit_email" name="email" required>
                            </div>
                            <div class="col-md-4">
                                <label for="edit_telefono" class="form-label">Teléfono</label>
                                <input type="text" class="form-control" id="edit_telefono" name="telefono">
                            </div>
                            <div class="col-md-4">
                                <label for="edit_direccion" class="form-label">Dirección</label>
                                <input type="text" class="form-control" id="edit_direccion" name="direccion">
                            </div>
                            <div class="col-md-4">
                                <label for="edit_departamento" class="form-label">Departamento</label>
                                <input type="text" class="form-control" id="edit_departamento" name="departamento">
                            </div>
                            <div class="col-md-4">
                                <label for="edit_cargo" class="form-label">Cargo</label>
                                <input type="text" class="form-control" id="edit_cargo" name="cargo">
                            </div>
                            <div class="col-md-8">
                                <label class="form-label">Roles</label>
                                <div id="edit_roles" class="row">
                                    <!-- Se cargarán dinámicamente los roles aquí -->
                                </div>
                            </div>
                            <div class="col-md-8 mt-3">
                                <label class="form-label">Áreas</label>
                                <div id="edit_areas" class="row">
                                    <!-- Aquí cargaremos dinámicamente las áreas -->
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalImportarDocentes" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formImportarDocentes" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="modal-content">

                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-file-excel"></i> Importación Masiva de Docentes
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <!-- SUBIR ARCHIVO -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Subir Archivo Excel</label>
                            <input type="file" name="archivo" class="form-control" required>
                            <small class="text-muted">Formatos permitidos: .xlsx, .xls</small>
                        </div>

                        <!-- INSTRUCCIONES -->
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Instrucciones</label>
                            <ul class="small">
                                <li>Descarga la plantilla modelo.</li>
                                <li>Completa los campos solicitados: <strong>DNI, Nombre, Apellido, Email, Departamento, Cargo</strong>.</li>
                                <li>El sistema asignará automáticamente el rol <strong>Docente</strong>.</li>
                                <li>El usuario será el mismo <strong>DNI</strong>, y la clave generada será: <strong>Docente@DNI</strong>.</li>
                            </ul>

                            <a href="<?php echo e(asset('plantillas/plantilla_docentes.xlsx')); ?>"
                                class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Plantilla
                            </a>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload"></i> Importar Docentes
                    </button>
                </div>

            </div>

        </form>
    </div>
</div>

<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables CSS -->
<script>
    $(document).ready(function () {
        $("#tablaDocentes").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaDocentes_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- agregar -->
<script>
    $(document).ready(function() {
        // Enviar el formulario por Ajax
        $('#formNuevoDocente').submit(function(event) {
            event.preventDefault();  // Evitar la recarga de la página

            let formData = new FormData(this);  // Crear un objeto FormData para enviar los datos

            $.ajax({
                url: $(this).attr('action'),  // URL donde se enviará la solicitud
                type: 'POST',
                data: formData,
                processData: false,  // No procesar los datos
                contentType: false,  // No establecer un tipo de contenido específico
                success: function(response) {
                    // Mostrar SweetAlert de éxito
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: response.success,
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        // Cerrar el modal después de un éxito
                        $('#modalNuevoDocente').modal('hide');
                        // Opcional: Recargar la página o actualizar la tabla
                        location.reload();
                    });
                },
                error: function(response) {
                    // Mostrar SweetAlert de error
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: response.responseJSON.error || 'Ocurrió un error inesperado.',
                        confirmButtonText: 'Intentar nuevamente'
                    });
                }
            });
        });
    });

</script>
<!-- editar -->
<script>
    $(document).ready(function () {
        $(document).on('click', '.btn-editar-docente', function () {
            const docenteId = $(this).data('id');
            const nombre = $(this).data('nombre');
            const apellido = $(this).data('apellido');
            const email = $(this).data('email');
            const telefono = $(this).data('telefono');
            const direccion = $(this).data('direccion');
            const departamento = $(this).data('departamento');
            const cargo = $(this).data('cargo');

            // Llenar los campos del formulario
            $('#edit_nombre').val(nombre);
            $('#edit_apellido').val(apellido);
            $('#edit_email').val(email);
            $('#edit_telefono').val(telefono);
            $('#edit_direccion').val(direccion);
            $('#edit_departamento').val(departamento);
            $('#edit_cargo').val(cargo);

            // Limpiar y cargar roles y áreas asignados
            $.ajax({
                url: '/docentes/' + docenteId + '/roles',  // Endpoint que retorna roles y áreas
                method: 'GET',
                success: function (response) {
                    const rolesAsignados = response.rolesDelDocente || [];
                    const rolesDisponibles = response.roles || [];

                    const areasAsignadas = response.areasDelDocente || [];
                    const areasDisponibles = response.areas || [];

                    // Cargar roles
                    $('#edit_roles').empty();
                    rolesDisponibles.forEach(function (rol) {
                        const checked = rolesAsignados.includes(rol.id) ? 'checked' : '';
                        $('#edit_roles').append(`
                            <div class="form-check col-md-6">
                                <input class="form-check-input" type="checkbox" name="roles[]" value="${rol.id}" ${checked}>
                                <label class="form-check-label">${rol.nombre}</label>
                            </div>
                        `);
                    });

                    // Cargar áreas
                    $('#edit_areas').empty();
                    areasDisponibles.forEach(function (area) {
                        const checked = areasAsignadas.includes(area.id) ? 'checked' : '';
                        $('#edit_areas').append(`
                            <div class="form-check col-md-6">
                                <input class="form-check-input" type="checkbox" name="areas[]" value="${area.id}" ${checked}>
                                <label class="form-check-label">${area.nombre}</label>
                            </div>
                        `);
                    });
                },
                error: function () {
                    console.error('Error al cargar los roles y áreas del docente.');
                }
            });

            // Establecer la acción del formulario
            $('#formEditarDocente').attr('action', '/docentes/' + docenteId);
        });

        // Enviar el formulario con AJAX
        $('#formEditarDocente').submit(function (event) {
            event.preventDefault();

            let formData = new FormData(this);
            formData.append('_method', 'PUT');

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Éxito!',
                        text: 'Docente actualizado correctamente.',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        $('#editModal').modal('hide');
                        location.reload();
                    });
                },
                error: function (xhr) {
                    let errorMsg = 'Ocurrió un error al actualizar el docente.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMsg = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: errorMsg,
                        confirmButtonText: 'Intentar nuevamente'
                    });
                }
            });
        });
    });
</script>


<script>
    $(document).ready(function () {
    $(document).on('click', '.btn-eliminar-docente', function (e) {
        e.preventDefault();
        const docenteId = $(this).data('id');

        // Mostrar alerta de confirmación antes de eliminar
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Este docente será eliminado permanentemente!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Realizar la solicitud AJAX para eliminar el docente
                $.ajax({
                    url: '/docentes/' + docenteId,  // Ruta al controlador de eliminación
                    type: 'DELETE',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',  // Incluir CSRF token para validación
                    },
                    success: function (response) {
                        // Mostrar mensaje de éxito y recargar la página
                        Swal.fire({
                            icon: 'success',
                            title: '¡Eliminado!',
                            text: 'El docente y su usuario han sido eliminados correctamente.',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            location.reload(); // Recargar la página para reflejar los cambios
                        });
                    },
                    error: function (xhr, status, error) {
                        // Mostrar mensaje de error
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: 'Ocurrió un problema al eliminar al docente.',
                            confirmButtonText: 'Intentar nuevamente'
                        });
                    }
                });
            }
        });
    });
});

</script>


<script>
$(document).ready(function () {

    $('#formImportarDocentes').submit(function (event) {
        event.preventDefault();

        let formData = new FormData(this);

        Swal.fire({
            title: 'Importando...',
            text: 'Procesando archivo, por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "<?php echo e(route('docentes.importar')); ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {

                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Importación exitosa',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });

                $('#modalImportarDocentes').modal('hide');

                setTimeout(() => location.reload(), 1500);
            },

            error: function (xhr) {

                Swal.close();

                if (xhr.status === 422) {
                    let errores = xhr.responseJSON.errors ?? [];
                    let mensaje = errores.join("<br>");

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores en el archivo',
                        html: mensaje
                    });
                    return;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error inesperado',
                    text: xhr.responseJSON?.message ?? 'No se pudo procesar el archivo.'
                });
            }
        });
    });

});
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/docentes/index.blade.php ENDPATH**/ ?>