<?php $__env->startSection('title'); ?> Perfil Estudiante <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('components.breadcrumb'); ?>
    <?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
    <?php $__env->slot('li_2'); ?> Panel Estudiante <?php $__env->endSlot(); ?>
    <?php $__env->slot('title'); ?> Perfil del Estudiante <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0 mb-4">
            <!-- Encabezado limpio -->
            <div class="card-header bg-white border-bottom">
                <h5 class="mb-0 text-primary fw-semibold">Ficha de Presentación del Estudiante</h5>
            </div>

            <div class="card-body">
                <div class="row g-4">
                    <!-- Columna Izquierda: Perfil -->
                    <div class="col-lg-4 text-center">
                        <img src="<?php echo e($postulante->foto_postulante ? asset($postulante->foto_postulante) : asset('assets/images/users/avatar-1.jpg')); ?>"
                             class="img-fluid rounded-circle border border-3 shadow-sm mb-3"
                             width="130" alt="Foto del estudiante">

                        <h5 class="mb-1"><?php echo e($postulante->nombres); ?> <?php echo e($postulante->apellidos); ?></h5>
                        <p class="text-muted mb-1">Código: <strong><?php echo e($postulante->codigo_postulante); ?></strong></p>
                        <p class="text-muted mb-1">Email: <strong><?php echo e($postulante->email); ?></strong></p>
                        <p class="text-muted mb-3">Teléfono: <strong><?php echo e($postulante->telefono); ?></strong></p>

                        <!-- Botón de acción discreto -->
                        <a href="<?php echo e(route('estudiantes.perfil')); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-edit me-1"></i> Editar Perfil
                        </a>
                    </div>

                    <!-- Columna Derecha: Información -->
                    <div class="col-lg-8">
                        <!-- Datos Personales -->
                        <div class="mb-4">
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Datos Personales</h6>
                            <div class="row">
                                <?php
                                    $personales = [
                                        'DNI' => $postulante->dni,
                                        'Género' => $postulante->genero,
                                        'Fecha de Nacimiento' => $postulante->fecha_nacimiento,
                                        'Lengua Materna' => $postulante->lengua_materna,
                                        'Dirección' => $postulante->direccion,
                                        'Discapacidad' => $postulante->discapacidad ? 'Sí' : 'No',
                                        'Tipo de Discapacidad' => $postulante->discapacidad ? $postulante->nombre_discapacidad : null,
                                    ];
                                ?>

                                <?php $__currentLoopData = $personales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value): ?>
                                        <div class="col-md-6 mb-2">
                                            <strong><?php echo e($label); ?>:</strong> <?php echo e($value); ?>

                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <!-- Información Académica -->
                        <div class="mb-4">
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Información Académica</h6>
                            <div class="row">
                                <?php
                                    $academica = [
                                        'Colegio' => $postulante->colegio->nombre ?? 'No registrado',
                                        'Año de Egreso' => $postulante->año_egreso,
                                        'Fuente de Inscripción' => $postulante->fuente_inscripcion,
                                        'Grado' => $postulante->grado,
                                        
                                    ];
                                ?>

                                <?php $__currentLoopData = $academica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value): ?>
                                        <div class="col-md-6 mb-2">
                                            <strong><?php echo e($label); ?>:</strong> <?php echo e($value); ?>

                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <!-- Documentos Subidos -->
                        <div>
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Documentos Subidos</h6>
                            <div class="row g-3">
                                <?php $__currentLoopData = [
                                    'Certificado de Estudios' => $postulante->certificado_estudios,
                                    'Partida de Nacimiento' => $postulante->partida_nacimiento,
                                    'Comprobante de Pago' => $postulante->comprobante_pago,
                                    'Copia de DNI' => $postulante->copia_dni,
                                    'Currículum Vitae' => $postulante->curriculum_archivo,
                                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nombre => $archivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6">
                                        <div class="border rounded p-3 d-flex justify-content-between align-items-center">
                                            <span class="fw-semibold"><?php echo e($nombre); ?></span>
                                            <?php if($archivo): ?>
                                                <a href="<?php echo e(asset($archivo)); ?>" class="text-success text-decoration-none small" target="_blank">
                                                    Ver documento <i class="fas fa-file-alt ms-1"></i>
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted small">No registrado</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>


                    </div> <!-- /col-lg-8 -->
                </div> <!-- /row -->
            </div> <!-- /card-body -->
        </div>
    </div>
</div>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/estudiantes/perfil_show.blade.php ENDPATH**/ ?>