<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Aula extends Model
{
    use HasFactory;

    protected $table = 'aulas';
    protected $primaryKey = 'id';

    protected $fillable = [
        'nombre',
        'capacidad',
        'numero_aula',
        'id_pabellon',
        'tipo',
    ];

    /**
     * Un aula pertenece a un pabellón
     */
    public function pabellon()
    {
        return $this->belongsTo(Pabellon::class, 'id_pabellon');
    }

    /**
     * Un aula puede tener muchos horarios
     */
    public function horarios()
    {
        return $this->hasMany(Horario::class, 'id_aula');
    }
}
