<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Curso extends Model
{
    use HasFactory;

    // Definir el nombre de la tabla en la base de datos
    protected $table = 'cursos';

    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id';

    // Definir los campos que se pueden asignar masivamente
    protected $fillable = [
        'nombre',
        'descripcion',
        'semestre_id',
        'tipo',
        'id_modulo',
        'creditos',
        'horas_semestrales',
        'orden','moodle_course_id',
    ];

    // Relación con el modelo Semestre (un curso pertenece a un semestre)
    public function semestre()
    {
        return $this->belongsTo(Semestre::class, 'semestre_id');
    }

    // Relación con el modelo ModuloFormativo (un curso pertenece a un módulo formativo)
    public function modulo()
    {
        return $this->belongsTo(ModuloFormativo::class, 'id_modulo');
    }

    // Relación con la tabla intermedia cursos_plan_estudio (un curso puede estar relacionado con varios planes de estudio)
    public function cursosPlanEstudios()
    {
        return $this->hasMany(CursosPlanEstudio::class, 'curso_id');
    }

    // Relación con PlanEstudio (muchos a muchos) a través de la tabla intermedia
    public function planesEstudio()
    {
        return $this->belongsToMany(PlanEstudio::class, 'cursos_plan_estudio', 'curso_id', 'plan_estudio_id');
    }

    // Relación con el modelo MatriculaCurso (un curso puede tener muchas matrículas)
    public function matriculaCursos()
    {
        return $this->hasMany(MatriculaCurso::class, 'curso_id');
    }

    public function docentes()
    {
        return $this->belongsToMany(Docente::class, 'cursos_docentes', 'curso_id', 'docente_id');
    }

    public function horarios()
    {
        return $this->hasMany(Horario::class, 'id_curso');
    }
    public function notaFinal()
    {
        return $this->hasMany(NotaFinal::class, 'curso_id');
    }

}
