@extends('layouts.master')

@section('title', 'Detalle del Curso')

@section('content')
<div class="container mt-4">
    <h3 class="mb-4 text-primary">{{ $curso->nombre }}</h3>

    <div class="accordion" id="accordionSesiones">
        @forelse($sesiones as $sesion)
        <div class="accordion-item rounded-3 shadow-sm mb-3 border-0">
            <h2 class="accordion-header" id="heading{{ $sesion->id_sesion }}">
                <button class="accordion-button collapsed rounded-3 d-flex justify-content-between align-items-center"
                    type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse{{ $sesion->id_sesion }}"
                    aria-expanded="false" aria-controls="collapse{{ $sesion->id_sesion }}">
                    <div>
                        <strong>{{ $sesion->nombre }}</strong> 
                        <small class="text-muted ms-2">({{ \Carbon\Carbon::parse($sesion->fecha)->format('d/m/Y') }})</small>
                    </div>
                    <span class="badge bg-{{ $sesion->activo ? 'success' : 'secondary' }}">
                        {{ $sesion->activo ? 'Activa' : 'Inactiva' }}
                    </span>
                </button>
            </h2>

            <div id="collapse{{ $sesion->id_sesion }}" class="accordion-collapse collapse"
                aria-labelledby="heading{{ $sesion->id_sesion }}" data-bs-parent="#accordionSesiones">
                <div class="accordion-body py-4">
                    <ul class="nav nav-tabs mb-3" id="tabs{{ $sesion->id_sesion }}" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="archivos-tab-{{ $sesion->id_sesion }}" data-bs-toggle="tab" data-bs-target="#archivos-{{ $sesion->id_sesion }}" type="button" role="tab" aria-controls="archivos-{{ $sesion->id_sesion }}" aria-selected="true">
                                Archivos
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="videos-tab-{{ $sesion->id_sesion }}" data-bs-toggle="tab" data-bs-target="#videos-{{ $sesion->id_sesion }}" type="button" role="tab" aria-controls="videos-{{ $sesion->id_sesion }}" aria-selected="false">
                                Videos
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="tabsContent{{ $sesion->id_sesion }}">
                        {{-- Archivos --}}
                        <div class="tab-pane fade show active" id="archivos-{{ $sesion->id_sesion }}" role="tabpanel" aria-labelledby="archivos-tab-{{ $sesion->id_sesion }}">
                            @if($sesion->archivos->where('tipo', 'archivo')->isEmpty())
                                <p class="text-muted fst-italic">No hay archivos disponibles.</p>
                            @else
                                <ul class="list-group list-group-flush">
                                    @foreach($sesion->archivos->where('tipo', 'archivo') as $archivo)
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                                            <div class="d-flex align-items-center gap-3">
                                                <i class="bi bi-file-earmark-pdf-fill text-danger fs-4"></i>
                                                <span>{{ $archivo->nombre }}</span>
                                            </div>
                                            <a href="{{ asset('storage/archivos_curso/' . $archivo->ruta) }}" target="_blank" 
                                            class="btn btn-sm btn-outline-primary"
                                            style="max-width:120px; padding:0.25rem 0.5rem; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; font-size:0.875rem;"
                                            rel="noopener noreferrer" 
                                            aria-label="Descargar {{ $archivo->nombre }}">
                                                Descargar
                                            </a>

                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>

                        {{-- Videos --}}
                        <div class="tab-pane fade" id="videos-{{ $sesion->id_sesion }}" role="tabpanel" aria-labelledby="videos-tab-{{ $sesion->id_sesion }}">
                            @if($sesion->archivos->where('tipo', 'video')->isEmpty())
                                <p class="text-muted fst-italic">No hay videos disponibles.</p>
                            @else
                                <div class="row row-cols-1 row-cols-md-2 g-4">
                                    @foreach($sesion->archivos->where('tipo', 'video') as $video)
                                        @php
                                            $youtubeId = null;
                                            if (str_contains($video->ruta, 'youtube.com') || str_contains($video->ruta, 'youtu.be')) {
                                                if (str_contains($video->ruta, 'youtu.be')) {
                                                    $parts = explode('/', $video->ruta);
                                                    $youtubeId = end($parts);
                                                } else {
                                                    parse_str(parse_url($video->ruta, PHP_URL_QUERY), $queryParams);
                                                    $youtubeId = $queryParams['v'] ?? null;
                                                }
                                            }
                                        @endphp
                                        <div class="col">
                                            <div class="card shadow-sm rounded-3 h-100">
                                                @if($youtubeId)
                                                    <div class="ratio ratio-16x9 rounded-top">
                                                        <iframe 
                                                            src="https://www.youtube.com/embed/{{ $youtubeId }}" 
                                                            title="{{ $video->nombre }}" 
                                                            allowfullscreen 
                                                            loading="lazy"
                                                            frameborder="0"
                                                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                                            class="rounded-top">
                                                        </iframe>
                                                    </div>
                                                @else
                                                    <video controls preload="metadata" class="w-100 rounded-top">
                                                        <source src="{{ asset('storage/archivos_curso/' . $video->ruta) }}" type="video/mp4">
                                                        Tu navegador no soporta video HTML5.
                                                    </video>
                                                @endif
                                                <div class="card-body">
                                                    <h6 class="card-title mb-0 text-truncate" title="{{ $video->nombre }}">{{ $video->nombre }}</h6>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @empty
            <div class="alert alert-info">No hay sesiones registradas aún.</div>
        @endforelse
    </div>
</div>
@endsection
