<div class="card">
    <div class="card-header">
        <h5 class="card-title">Trámites Documentarios</h5>
    </div>
    <div class="card-body">
        @if($tramitesMesa->isEmpty())
            <p>No hay trámites disponibles.</p>
        @else
            <table id="tablaRoles" class="table table-striped mb-0 table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Estudiante</th>
                        <th>Tipo</th>
                        <th>Estado</th>
                        <th>Fecha</th>
                        <th>Documento</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($tramitesMesa as $tramite)
                        <tr>
                            <td>{{ $tramite->id }}</td>
                            <td>{{ $tramite->estudiante }}</td>
                            <td>{{ $tramite->tipo_tramite }}</td>
                            <td>{{ ucfirst($tramite->estado) }}</td>
                            <td>{{ \Carbon\Carbon::parse($tramite->fecha_solicitud)->format('d/m/Y H:i') }}</td>
                            <td class="text-center">
                                @if($tramite->archivo)
                                    <a href="{{ asset('tramites/' . $tramite->archivo) }}" target="_blank" class="btn btn-sm btn-outline-secondary" title="Ver archivo">
                                        <i class="bi bi-file-earmark-text"></i>
                                    </a>
                                @else
                                    <span class="text-muted">Sin archivo</span>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-outline-primary btn-sm" onclick="derivarTramite({{ $tramite->id }})" title="Derivar">
                                    <i class="bi bi-arrow-right-circle"></i>
                                </button>
                                <button class="btn btn-outline-success btn-sm" onclick="finalizarTramite({{ $tramite->id }})" title="Finalizar">
                                    <i class="bi bi-check-circle"></i>
                                </button>
                                <button class="btn btn-outline-danger btn-sm" onclick="rechazarTramite({{ $tramite->id }})" title="Rechazar">
                                    <i class="bi bi-x-circle"></i>
                                </button>
                                <button class="btn btn-outline-info btn-sm" onclick="verTrazabilidad({{ $tramite->id }})" title="Ver trazabilidad">
                                    <i class="bi bi-clock-history"></i>
                                </button>
                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
</div>

<!-- Modal Derivación -->
<div class="modal fade" id="modalDerivar" tabindex="-1" aria-labelledby="modalDerivarLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formDerivarTramite" enctype="multipart/form-data">
      @csrf
      <input type="hidden" name="solicitud_id" id="inputSolicitudId">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Derivar Trámite</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="area_destino_id" class="form-label">Área destino</label>
            <select class="form-select" name="area_destino_id" required>
              <option value="" disabled selected>Seleccione un área</option>
              @foreach($areas as $area)
                <option value="{{ $area->id }}">{{ $area->nombre }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-3">
            <label for="observacion" class="form-label">Observación</label>
            <textarea name="observacion" class="form-control" rows="3" placeholder="Ingrese una observación..."></textarea>
          </div>
          <div class="mb-3">
            <label for="archivo_derivacion" class="form-label">Archivo de derivación (opcional)</label>
            <input type="file" name="archivo_derivacion" class="form-control" accept=".pdf,.doc,.docx,.jpg,.png">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Derivar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>
<!-- Modal Reachazar -->
<div class="modal fade" id="modalRechazar" tabindex="-1" aria-labelledby="modalRechazarLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formRechazarTramite" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="solicitud_id" id="rechazarSolicitudId">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="modalRechazarLabel">Rechazar Trámite</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="motivoRechazo" class="form-label">Motivo del rechazo</label>
                        <textarea name="motivo" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Rechazar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>
<!-- Modal trasavilidad -->
<div class="modal fade" id="modalTrazabilidad" tabindex="-1" aria-labelledby="modalTrazabilidadLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Trazabilidad del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="contenidoTrazabilidad"></div>
      </div>
    </div>
  </div>
</div>
<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- tabla -->
<script>
    $(document).ready(function () {
        $("#tablaRoles").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaRoless_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- derivar -->
<script>
    function derivarTramite(id) {
        $('#inputSolicitudId').val(id);
        $('#formDerivarTramite')[0].reset();
        $('#modalDerivar').modal('show');
    }

    $('#formDerivarTramite').submit(function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        Swal.fire({
            title: '¿Está seguro?',
            text: "Esta acción derivará el trámite a otra área.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, derivar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('tramites.derivar') }}",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (res) {
                        Swal.fire({
                            title: '¡Éxito!',
                            text: res.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then(() => {
                            $('#modalDerivar').modal('hide');
                            // Puedes recargar o actualizar la tabla con AJAX si lo deseas
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        let errorMsg = 'Error al derivar el trámite.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMsg = xhr.responseJSON.message;
                        }
                        Swal.fire('Error', errorMsg, 'error');
                    }
                });
            }
        });
    });
</script>
<!-- rechazar -->
<script>
    function rechazarTramite(id) {
        $('#rechazarSolicitudId').val(id);
        $('#formRechazarTramite')[0].reset();
        $('#modalRechazar').modal('show');
    }

    $('#formRechazarTramite').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        Swal.fire({
            title: '¿Está seguro?',
            text: "El trámite será marcado como rechazado.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#aaa',
            confirmButtonText: 'Sí, rechazar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('tramites.rechazar') }}",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (res) {
                        Swal.fire('Rechazado', res.message, 'success').then(() => {
                            $('#modalRechazar').modal('hide');
                            location.reload(); // o eliminar fila con JS si prefieres
                        });
                    },
                    error: function () {
                        Swal.fire('Error', 'Hubo un problema al rechazar el trámite.', 'error');
                    }
                });
            }
        });
    });
</script>
<!-- finalizar -->
<script>
    function finalizarTramite(id) {
        Swal.fire({
            title: '¿Finalizar Trámite?',
            text: "Esta acción marcará el trámite como completado.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, finalizar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('tramites.finalizar') }}",
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        solicitud_id: id
                    },
                    success: function (res) {
                        Swal.fire('Finalizado', res.message, 'success');
                        setTimeout(() => location.reload(), 1500);
                    },
                    error: function (err) {
                        Swal.fire('Error', 'No se pudo finalizar el trámite.', 'error');
                    }
                });
            }
        });
    }
</script>

<!-- trasavilidad -->
<script>
    function verTrazabilidad(solicitudId) {
        $('#contenidoTrazabilidad').html('<p>Cargando...</p>');
        $('#modalTrazabilidad').modal('show');

        $.get("{{ url('/tramites/trazabilidad') }}/" + solicitudId, function (res) {
            $('#contenidoTrazabilidad').html(res.html);
        }).fail(function () {
            $('#contenidoTrazabilidad').html('<div class="alert alert-danger">No se pudo cargar el historial.</div>');
        });
    }
</script>