<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
        }
        .center {
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .logo {
            width: 70px;
            height: auto;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="center">
        @if($instituto && $instituto->logo)
            <img src="{{ public_path('storage/' . $instituto->logo) }}" alt="Logo" class="logo">
        @endif
        <div class="bold">{{ $instituto->nombre ?? 'INSTITUTO' }}</div>
        <div>{{ $instituto->direccion ?? '' }}</div>
        <div>Tel: {{ $instituto->telefono ?? '' }}</div>
        <div>Cod. Modular: {{ $instituto->codigo_modular ?? '' }}</div>
        <div>Dre: {{ $instituto->dre ?? '' }}</div>
        
        <div class="line"></div>
        <div class="bold">COMPROBANTE DE TRANSACCIÓN</div>
    </div>

    <div class="line"></div>
    <div><strong>Fecha:</strong> {{ \Carbon\Carbon::parse($transaccion->fecha)->format('d/m/Y') }}</div>
    <div><strong>Tipo:</strong> {{ ucfirst($transaccion->tipo) }}</div>
    <div><strong>Concepto:</strong> {{ $transaccion->concepto->nombre ?? '-' }}</div>
    <div><strong>Monto:</strong> S/ {{ number_format($transaccion->monto, 2) }}</div>
    <div><strong>Estado:</strong> {{ ucfirst($transaccion->estado) }}</div>

    <div class="line"></div>
    <div><strong>DNI:</strong> {{ $transaccion->dni ?? '-' }}</div>
    <div><strong>Apellidos:</strong> {{ $transaccion->apellidos ?? '-' }}</div>
    <div><strong>Nombres:</strong> {{ $transaccion->nombres ?? '-' }}</div>
    <div><strong>Caja:</strong> {{ $transaccion->caja->nombre ?? '-' }}</div>

    <div class="line"></div>
    <div><strong>Obs:</strong> {{ $transaccion->observacion ?? '---' }}</div>
    <div class="line"></div>

    <div class="center">Gracias por su pago</div>
</body>
</html>
