<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Tramite Documentario <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Requisitos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoRequisito">
                    <i class="fas fa-plus"></i> Agregar Nuevo Requisito
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($requisito->id); ?></td>
                                    <td><?php echo e($requisito->descripcion); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($requisito->estado == 'Activo' ? 'bg-success' : 'bg-secondary'); ?>">
                                            <?php echo e($requisito->estado); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <!-- Icono de editar -->
                                        <a href="#" 
                                        class="text-warning me-2 btn-editar-requisito"
                                        data-id="<?php echo e($requisito->id); ?>"
                                        data-descripcion="<?php echo e($requisito->descripcion); ?>"
                                        data-estado="<?php echo e($requisito->estado); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>


                                        <!-- Icono de eliminar -->
                                        <a href="#" 
                                        class="btn-eliminar-requisito text-danger" 
                                        data-id="<?php echo e($requisito->id); ?>">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </a>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">No hay requisitos registrados.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>



                     

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal: Nuevo Requisito -->
<!-- Modal: Nuevo Requisito -->
<div class="modal fade" id="modalNuevoRequisito" tabindex="-1" aria-labelledby="modalNuevoRequisitoLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <form id="formNuevoRequisito">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalNuevoRequisitoLabel">Agregar Nuevo Requisito</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <!-- Descripción -->
                    <div class="mb-3">
                        <label for="descripcion" class="form-label">Descripción <span class="text-danger">*</span></label>
                        <input type="text" name="descripcion" id="descripcion" class="form-control" required>
                    </div>

                    <!-- Estado -->
                    <div class="mb-3">
                        <label for="estado" class="form-label">Estado</label>
                        <select name="estado" id="estado" class="form-select">
                            <option value="Activo" selected>Activo</option>
                            <option value="Inactivo">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Requisito</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Modal para editar requisito -->
<div class="modal fade" id="modalEditarRequisito" tabindex="-1" aria-labelledby="modalEditarRequisitoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarRequisito">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <input type="hidden" id="edit_requisito_id">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="modalEditarRequisitoLabel">Editar Requisito</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
          </div>
          <div class="modal-body">
            <div class="mb-3">
              <label for="edit_descripcion" class="form-label">Descripción</label>
              <input type="text" class="form-control" id="edit_descripcion" name="descripcion" required>
            </div>
            <div class="mb-3">
              <label for="edit_estado" class="form-label">Estado</label>
              <select class="form-select" id="edit_estado" name="estado" required>
                <option value="Activo">Activo</option>
                <option value="Inactivo">Inactivo</option>
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
            <button type="submit" class="btn btn-primary">Guardar Cambios</button>
          </div>
        </div>
    </form>
  </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        $('#formNuevoRequisito').on('submit', function (e) {
            e.preventDefault();

            let form = $(this);
            let url = "<?php echo e(route('requisitos_tramite.store')); ?>";
            let formData = form.serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Requisito registrado!',
                        text: 'El requisito se ha guardado correctamente.',
                        timer: 2000,
                        showConfirmButton: true
                    });

                    // Cerrar el modal
                    $('#modalNuevoRequisito').modal('hide');

                    // Limpiar el formulario
                    form[0].reset();

                    // Recargar tabla o agregar nuevo requisito a la tabla (dependiendo de cómo estés cargando)
                    location.reload(); // puedes reemplazar esto por una actualización AJAX de la tabla
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON?.errors;

                    let mensaje = 'Ocurrió un error al guardar.';

                    if (errores) {
                        mensaje = Object.values(errores).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        $('.btn-eliminar-requisito').click(function (e) {
            e.preventDefault();
            const id = $(this).data('id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: 'Esta acción no se puede deshacer',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/requisitos_tramite/${id}`,
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            _method: 'DELETE'
                        },
                        success: function (response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: response.message
                            }).then(() => {
                                location.reload(); // o elimina la fila con JS
                            });
                        },
                        error: function () {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'No se pudo eliminar el requisito.'
                            });
                        }
                    });
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcarhuaz.dedu.pe/resources/views/requisitos_tramite/index.blade.php ENDPATH**/ ?>