<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Empresas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevaEmpresa">
                    <i class="fas fa-plus"></i> Agregar Nueva Empresa
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                             <tr>
                                <th>#</th>
                                <th>Nombre</th>
                                <th>Logo</th>
                                <th>Dirección</th>
                                <th>Teléfono</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                             <?php $__empty_1 = true; $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($empresa->id_empresa); ?></td>
                                    <td><?php echo e($empresa->nombre_empresa); ?></td>
                                    <td>
                                        <?php if($empresa->logo_empresa): ?>
                                            <img src="<?php echo e(asset('empresas/' . $empresa->logo_empresa)); ?>" alt="Logo" width="50">

                                        <?php else: ?>
                                            <span class="text-muted">Sin logo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($empresa->direccion_empresa); ?></td>
                                    <td><?php echo e($empresa->telefono_empresa); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($empresa->estado === 'Activo' ? 'success' : 'secondary'); ?>">
                                            <?php echo e($empresa->estado); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <!-- Ícono de editar -->
                                        <a href="#"
                                            class="text-warning"
                                            data-bs-toggle="modal"
                                            data-bs-target="#editEmpresaModal"
                                            data-id="<?php echo e($empresa->id_empresa); ?>"
                                            data-nombre="<?php echo e($empresa->nombre_empresa); ?>"
                                            data-direccion="<?php echo e($empresa->direccion_empresa); ?>"
                                            data-telefono="<?php echo e($empresa->telefono_empresa); ?>"
                                            data-logo="<?php echo e($empresa->logo_empresa); ?>"
                                            data-estado="<?php echo e($empresa->estado); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <!-- Ícono de eliminar -->
                                        <form class="formEliminarEmpresa d-inline" data-id="<?php echo e($empresa->id_empresa); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-link p-0" style="border: none;">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </button>
                                        </form>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted">No hay empresas registradas.</td>
                                </tr>
                            <?php endif; ?>

                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para nueva empresa -->
<div class="modal fade" id="modalNuevaEmpresa" tabindex="-1" aria-labelledby="modalNuevaEmpresaLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white"> <!-- fondo azul, texto blanco -->
                <h5 class="modal-title" id="modalNuevaEmpresaLabel">
                    <i class="fas fa-building me-2"></i> Nueva Empresa
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <form id="formNuevaEmpresa" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="mb-3">
                        <label for="nombre_empresa" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombre_empresa" name="nombre_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="logo_empresa" class="form-label">Logo</label>
                        <input type="file" class="form-control" id="logo_empresa" name="logo_empresa" accept="image/*">
                    </div>

                    <div class="mb-3">
                        <label for="direccion_empresa" class="form-label">Dirección</label>
                        <input type="text" class="form-control" id="direccion_empresa" name="direccion_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="telefono_empresa" class="form-label">Teléfono</label>
                        <input type="text" class="form-control" id="telefono_empresa" name="telefono_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="estado" class="form-label">Estado</label>
                        <select name="estado" id="estado" class="form-select">
                            <option value="Activo" selected>Activo</option>
                            <option value="Inactivo">Inactivo</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-de-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Modal Editar Empresa -->
<div class="modal fade" id="editEmpresaModal" tabindex="-1" aria-labelledby="editEmpresaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarEmpresa" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editEmpresaModalLabel">Editar Empresa</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id_empresa" id="edit_id_empresa">
                    
                    <div class="mb-3">
                        <label for="edit_nombre_empresa" class="form-label">Nombre</label>
                        <input type="text" class="form-control" name="nombre_empresa" id="edit_nombre_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_direccion_empresa" class="form-label">Dirección</label>
                        <input type="text" class="form-control" name="direccion_empresa" id="edit_direccion_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_telefono_empresa" class="form-label">Teléfono</label>
                        <input type="text" class="form-control" name="telefono_empresa" id="edit_telefono_empresa" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_logo_empresa" class="form-label">Logo (opcional)</label>
                        <input type="file" class="form-control" name="logo_empresa" id="edit_logo_empresa" accept="image/*">
                        <small class="text-muted">Deja vacío para mantener el actual.</small>
                        <div id="logo_actual" class="mt-2"></div>
                    </div>

                    <div class="mb-3">
                        <label for="edit_estado" class="form-label">Estado</label>
                        <select name="estado" id="edit_estado" class="form-select">
                            <option value="Activo">Activo</option>
                            <option value="Inactivo">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar Cambios</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>





<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Tablas CSS -->
<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<!-- Agregar CSS -->
<script>
$(document).ready(function() {
    $('#formNuevaEmpresa').submit(function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        $.ajax({
            url: "<?php echo e(route('empresass.store')); ?>",
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                $('#modalNuevaEmpresa').modal('hide'); // cerrar modal
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: 'Empresa creada correctamente',
                    timer: 2000,
                    showConfirmButton: false
                });

                // Opcional: recargar o actualizar la tabla con nuevas empresas
                setTimeout(() => {
                    location.reload(); // O mejor hacer actualización AJAX de tabla
                }, 2100);
            },
            error: function(xhr) {
                let errors = xhr.responseJSON?.errors;
                let message = 'Error desconocido';

                if (errors) {
                    message = Object.values(errors).map(errArr => errArr.join(', ')).join('\n');
                } else if (xhr.responseJSON?.message) {
                    message = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error al crear',
                    text: message,
                });
            }
        });
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('editEmpresaModal');

    modal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;

        document.getElementById('edit_id_empresa').value = button.getAttribute('data-id');
        document.getElementById('edit_nombre_empresa').value = button.getAttribute('data-nombre');
        document.getElementById('edit_direccion_empresa').value = button.getAttribute('data-direccion');
        document.getElementById('edit_telefono_empresa').value = button.getAttribute('data-telefono');
        document.getElementById('edit_estado').value = button.getAttribute('data-estado');

        const logo = button.getAttribute('data-logo');
        const logoContainer = document.getElementById('logo_actual');
        logoContainer.innerHTML = logo 
            ? `<img src="/empresas/${logo}" alt="Logo actual" width="50">`
            : `<span class="text-muted">Sin logo</span>`;
    });

    const formEditar = document.getElementById('formEditarEmpresa');
    formEditar.addEventListener('submit', function (e) {
        e.preventDefault();
        
        const formData = new FormData(formEditar);
        const id = formData.get('id_empresa');

        formData.append('_method', 'PUT'); // Laravel espera PUT

        fetch(`/empresass/${id}`, {
            method: 'POST', // Se envía como POST, Laravel reconocerá como PUT por _method
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => {
            if (!response.ok) throw new Error('Fallo en la solicitud');
            return response.json();
        })
        .then(data => {
            Swal.fire('Actualizado', data.message, 'success');
            const modalInstance = bootstrap.Modal.getInstance(modal);
            modalInstance.hide();
            setTimeout(() => location.reload(), 1200);
        })
        .catch(error => {
            Swal.fire('Error', 'Hubo un problema al actualizar la empresa.', 'error');
        });
    });
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.formEliminarEmpresa').forEach(form => {
        form.addEventListener('submit', function (e) {
            e.preventDefault();
            const id = form.getAttribute('data-id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`/empresass/${id}`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': form.querySelector('input[name="_token"]').value,
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: new URLSearchParams({
                            '_method': 'DELETE'
                        })
                    })
                    .then(response => {
                        if (!response.ok) throw new Error('Fallo en la solicitud');
                        return response.json();
                    })
                    .then(data => {
                        Swal.fire('Eliminado', data.message, 'success');
                        setTimeout(() => location.reload(), 1200);
                    })
                    .catch(error => {
                        Swal.fire('Error', 'No se pudo eliminar la empresa.', 'error');
                    });
                }
            });
        });
    });
});
</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcarhuaz.dedu.pe/resources/views/empresass/index.blade.php ENDPATH**/ ?>