<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Registo Practicas Profesionales <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="table-responsive">
                   
                    <form id="formPractica" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        
                        <div class="card mb-3 border border-primary">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0" style="color: white;">Datos del Estudiante</h5>
                            </div>
                            <div class="card-body row">
                                <div class="col-md-4">
                                    <label>DNI</label>
                                    <div class="input-group">
                                        <input type="text" id="dni" class="form-control" placeholder="Ingrese DNI">
                                        <button type="button" class="btn btn-outline-primary" id="btnBuscarDni">Buscar</button>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <label>Nombre completo</label>
                                    <input type="text" id="nombre_postulante" class="form-control" readonly>
                                </div>
                                <input type="hidden" name="postulante_id" id="postulante_id">
                            </div>
                        </div>

                        
                        <div class="card mb-3 border border-success">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0" style="color: white;">Módulo y Asesor</h5>
                            </div>
                            <div class="card-body row">
                                <div class="col-md-6">
                                    <label>Módulo Formativo</label>
                                    <select name="id_modulo" id="id_modulo" class="form-control" required>
                                        <option value="">Seleccione un módulo</option>
                                        
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Asesor (Docente Evaluador)</label>
                                    <select name="id_asesor" class="form-control" required>
                                        <option value="">Seleccione un asesor</option>
                                        <?php $__currentLoopData = $asesores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asesor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($asesor->id); ?>"><?php echo e($asesor->nombre); ?> <?php echo e($asesor->apellido); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        
                        <div class="card mb-3 border border-warning">
                            <div class="card-header bg-warning text-dark">
                                <h5 class="mb-0" style="color: white;">Datos de la Empresa</h5>
                            </div>
                            <div class="card-body row">
                                <div class="col-md-6">
                                    <label>Nombre de Empresa</label>
                                    <input type="text" name="empresa_nombre" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label>RUC</label>
                                    <input type="text" name="empresa_ruc" class="form-control" required>
                                </div>
                            </div>
                        </div>

                        
                        <div class="card mb-3 border border-info">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0" style="color: white;">Fechas y Evaluación</h5>
                            </div>
                            <div class="card-body row">
                                <div class="col-md-4">
                                    <label>Fecha Inicio</label>
                                    <input type="date" name="fecha_inicio" class="form-control" required>
                                </div>
                                <div class="col-md-4">
                                    <label>Fecha Fin</label>
                                    <input type="date" name="fecha_fin" class="form-control" required>
                                </div>
                                <div class="col-md-4">
                                    <label>Fecha de Registro</label>
                                    <input type="date" name="fecha_registro" class="form-control" value="<?php echo e(date('Y-m-d')); ?>">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Nota</label>
                                    <input type="number" name="nota" class="form-control" step="0.01">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Estado</label>
                                    <select name="estado" class="form-control">
                                        <option value="">Seleccione estado</option>
                                        <option value="pendiente">Pendiente</option>
                                        <option value="aprobado">Aprobado</option>
                                        <option value="desaprobado">Desaprobado</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label>Archivo de Evidencia</label>
                                    <input type="file" name="archivo_evidencia" class="form-control">
                                </div>
                            </div>
                        </div>

                        
                        <div class="card mb-3 border border-secondary">
                            <div class="card-header bg-secondary text-white">
                                <h5 class="mb-0" style="color: white;">Observaciones y Evidencia</h5>
                            </div>
                            <div class="card-body row">
                                <div class="col-md-12">
                                    <label>Observaciones</label>
                                    <textarea name="observacion" class="form-control" rows="3"></textarea>
                                </div>
                                
                            </div>
                        </div>

                        
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary px-4">Registrar Práctica</button>
                        </div>
                    </form>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById('btnBuscarDni').addEventListener('click', function () {
    let dni = document.getElementById('dni').value;

    if (!dni) {
        Swal.fire('Error', 'Ingrese un DNI válido.', 'error');
        return;
    }

    fetch(`/postulante/buscar-por-dni?dni=${dni}`)
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                // Mostrar nombre y ID del postulante
                document.getElementById('nombre_postulante').value = data.postulante.nombre;
                document.getElementById('postulante_id').value = data.postulante.id;

                // Cargar los módulos relacionados al plan de estudio del postulante
                fetch(`/modulos/por-postulante/${data.postulante.id}`)
                    .then(res => res.json())
                    .then(response => {
                        let selectModulo = document.getElementById('id_modulo');
                        selectModulo.innerHTML = '<option value="">Seleccione un módulo</option>';

                        if (response.success && response.modulos.length > 0) {
                            response.modulos.forEach(m => {
                                let opt = document.createElement('option');
                                opt.value = m.id_modulo;
                                opt.textContent = m.nombre;
                                selectModulo.appendChild(opt);
                            });
                        } else {
                            Swal.fire('Atención', 'El postulante no tiene módulos registrados.', 'info');
                        }
                    })
                    .catch(error => {
                        console.error(error);
                        Swal.fire('Error', 'No se pudieron cargar los módulos.', 'error');
                    });

            } else {
                Swal.fire('No encontrado', data.message, 'warning');
                document.getElementById('nombre_postulante').value = '';
                document.getElementById('postulante_id').value = '';
                document.getElementById('id_modulo').innerHTML = '<option value="">Seleccione un módulo</option>';
            }
        })
        .catch(error => {
            console.error(error);
            Swal.fire('Error', 'Ocurrió un error al buscar el DNI.', 'error');
        });
});
</script>


<script>
    document.getElementById('formPractica').addEventListener('submit', function (e) {
        e.preventDefault();

        const form = document.getElementById('formPractica');
        const formData = new FormData(form);

        Swal.fire({
            title: 'Registrando...',
            text: 'Espere un momento mientras se guarda la práctica.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        fetch('<?php echo e(route('practicass.store')); ?>', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
            }
        })
        .then(response => response.json())
        .then(data => {
            Swal.close();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: data.message || 'Práctica registrada correctamente.',
                }).then(() => {
                    window.location.href = "<?php echo e(route('practicass.index')); ?>";
                });
            } else {
                Swal.fire('Error', data.message || 'Ocurrió un error al registrar la práctica.', 'error');
            }
        })
        .catch(error => {
            console.error(error);
            Swal.close();
            Swal.fire('Error', 'Ocurrió un error en la solicitud.', 'error');
        });
    });
</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcarhuaz.dedu.pe/resources/views/practicass/create.blade.php ENDPATH**/ ?>