<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Requisitos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoRequisito">
                    <i class="fas fa-plus"></i> Agregar Nuevo Requisito
                </button>
                <div class="table-responsive">
                    <table id="tablaRequisitos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($requisito->id_requisito); ?></td>
                                    <td><?php echo e($requisito->nombre); ?></td>
                                    <td><?php echo e($requisito->descripcion); ?></td>
                                    <td>
                                        <?php if($requisito->activo): ?>
                                            <span class="badge badge-soft-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge badge-soft-warning">Inactivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <!-- Botón editar -->
                                        <a href="#"
                                            class="text-warning"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarRequisito"
                                            data-id="<?php echo e($requisito->id_requisito); ?>"
                                            data-nombre="<?php echo e($requisito->nombre); ?>"
                                            data-descripcion="<?php echo e($requisito->descripcion); ?>"
                                            data-activo="<?php echo e($requisito->activo); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <!-- Botón eliminar -->
                                        <form action="<?php echo e(route('requisitos.destroy', $requisito->id_requisito)); ?>" method="POST" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <!-- Botón de eliminación con AJAX -->
                                            <button type="button" class="btn btn-link p-0 m-0 align-baseline" id="deleteRequisito<?php echo e($requisito->id_requisito); ?>" data-id="<?php echo e($requisito->id_requisito); ?>">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </button>

                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->
<div class="modal fade" id="modalNuevoRequisito" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="formNuevoRequisito">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Agregar Nuevo Requisito</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre del Requisito</label>
                        <input type="text" class="form-control" name="nombre" id="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" name="descripcion" id="descripcion" rows="3"></textarea>
                    </div>
                    <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" id="activo" name="activo" checked>
                        <label class="form-check-label" for="activo">Activo</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Requisito</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="modalEditarRequisito" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarRequisito" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Requisito</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="edit_id" name="id_requisito">
                    
                    <div class="mb-3">
                        <label for="edit_nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_descripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="edit_descripcion" name="descripcion" rows="3"></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="edit_activo" class="form-label">Estado</label>
                        <select class="form-select form-select-sm" id="edit_activo" name="activo">
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>
                    

                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                </div>
            </div>
        </form>
    </div>
</div>





<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaRequisitos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaRequisitos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        $('#formNuevoRequisito').on('submit', function (e) {
            e.preventDefault();

            const formData = {
                nombre: $('#nombre').val(),
                descripcion: $('#descripcion').val(),
                activo: $('#activo').is(':checked') ? 1 : 0,
                _token: $('input[name="_token"]').val()
            };

            $.ajax({
                url: "<?php echo e(route('requisitos.store')); ?>",
                method: "POST",
                data: formData,
                success: function (response) {
                    $('#modalNuevoRequisito').modal('hide');
                    $('#formNuevoRequisito')[0].reset();

                    Swal.fire({
                        icon: 'success',
                        title: 'Requisito registrado',
                        text: 'El nuevo requisito se ha guardado correctamente.',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload(); // O puedes actualizar la tabla con JS si prefieres
                    });
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Hubo un problema al registrar el requisito.'
                    });
                }
            });
        });
    });
</script>

<script>
    $(document).ready(function () {
        $('#modalEditarRequisito').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);
            const id = button.data('id');
            const nombre = button.data('nombre');
            const descripcion = button.data('descripcion');
            const activo = button.data('activo');

            $('#edit_id').val(id);
            $('#edit_nombre').val(nombre);
            $('#edit_descripcion').val(descripcion);
            $('#edit_activo').val(activo); // Cambiar por el valor correcto

            const ruta = `/requisitos/${id}`;
            $('#formEditarRequisito').attr('action', ruta);
        });

        $('#formEditarRequisito').on('submit', function (e) {
            e.preventDefault();

            const form = $(this);
            const actionUrl = form.attr('action');

            const formData = {
                nombre: $('#edit_nombre').val(),
                descripcion: $('#edit_descripcion').val(),
                activo: $('#edit_activo').val(), // Ahora enviamos el valor del select
                _method: 'PUT',
                _token: $('input[name="_token"]').val()
            };

            $.ajax({
                url: actionUrl,
                type: 'POST',
                data: formData,
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Actualizado',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: true
                        });

                        $('#modalEditarRequisito').modal('hide');
                        setTimeout(() => location.reload(), 2000);
                    }
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON.errors;
                    let mensaje = 'Error al actualizar.';

                    if (errores) {
                        mensaje = Object.values(errores).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });

</script>

<script>
    $(document).ready(function () {
    // Cuando se haga clic en el botón de eliminar
    $('[id^="deleteRequisito"]').on('click', function () {
        const requisitoId = $(this).data('id'); // Obtener el ID del requisito desde el botón
        const url = `/requisitos/${requisitoId}`; // URL para la solicitud DELETE

        // Mostrar confirmación con SweetAlert
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Este requisito será eliminado permanentemente!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
        }).then((result) => {
            if (result.isConfirmed) {
                // Realizar la solicitud AJAX para eliminar el requisito
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    data: {
                        _token: $('meta[name="csrf-token"]').attr('content'), // Asegúrate de incluir el token CSRF
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Eliminado',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });
                        setTimeout(() => location.reload(), 2000); // Recargar la página después de 2 segundos
                    },
                    error: function (xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'No se pudo eliminar el requisito. Inténtalo nuevamente.',
                        });
                    }
                });
            }
        });
    });
});

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcarhuaz.dedu.pe/resources/views/requisitos/index.blade.php ENDPATH**/ ?>