<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startSection('css'); ?>

<link href="<?php echo e(URL::asset('assets/plugins/huebee/huebee.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(URL::asset('assets/plugins/datepicker/datepicker.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Periodos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <!-- Botón para agregar nueva matrícula -->
                
                    <a href="<?php echo e(route('matriculas.create')); ?>" 
                        class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                        data-bs-toggle="tooltip" data-bs-placement="right" title="Crear nueva matrícula">
                        <i class="fas fa-plus"></i> Agregar Matricula
                    </a>


                <!-- Filtros -->
                <form id="filtroMatriculas" action="<?php echo e(route('matriculas.index')); ?>" method="GET" class="mb-3">

                    <div class="row g-2 align-items-end">
                        <div class="col-md-3">
                            <label for="plan_estudio_id" class="form-label">Plan de Estudio</label>
                            <select name="plan_estudio_id" id="plan_estudio_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" <?php echo e(request()->plan_estudio_id == $plan->id ? 'selected' : ''); ?>>
                                        <?php echo e($plan->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="semestre_id" class="form-label">Semestre</label>
                            <select name="semestre_id" id="semestre_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($semestre->id); ?>" <?php echo e(request()->semestre_id == $semestre->id ? 'selected' : ''); ?>>
                                        <?php echo e($semestre->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="estado" class="form-label">Estado</label>
                            <select name="estado" id="estado" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <option value="Matriculado" <?php echo e(request()->estado == 'Matriculado' ? 'selected' : ''); ?>>Matriculado</option>
                                <option value="Pendiente" <?php echo e(request()->estado == 'Pendiente' ? 'selected' : ''); ?>>Pendiente</option>
                                <option value="Retirado" <?php echo e(request()->estado == 'Retirado' ? 'selected' : ''); ?>>Retirado</option>
                                <option value="Convalidado" <?php echo e(request()->estado == 'Convalidado' ? 'selected' : ''); ?>>Convalidado</option>
                                <option value="Repitencia" <?php echo e(request()->estado == 'Repitencia' ? 'selected' : ''); ?>>Repitencia</option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="fecha_matricula" class="form-label">Fecha</label>
                            <input type="date" name="fecha_matricula" id="fecha_matricula" 
                                class="form-control form-control-sm" value="<?php echo e(request()->fecha_matricula); ?>">
                        </div>

                        <div class="col-md-2 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-sm w-50">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                            <a href="<?php echo e(route('matriculas.index')); ?>" class="btn btn-secondary btn-sm w-50">
                                <i class="fas fa-sync-alt"></i> Limpiar
                            </a>

                        </div>
                    </div>
                </form>

                <!-- Tabla -->
                 
                    <!-- Contenedor donde se carga la tabla filtrada -->
                    <div id="tablaMatriculas">
                        <?php echo $__env->make('matriculas.partials.tabla', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                
            </div>

            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>
<!-- Modal de edición -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarMatricula" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Matrícula</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="edit_id" name="id">
                <div class="mb-2">
                    <label>Código Matrícula</label>
                    <input type="text" name="codigo_matricula" id="edit_codigo" class="form-control">
                </div>
                <div class="mb-2">
                    <label>Postulante</label>
                    <select name="postulante_id" id="edit_postulante" class="form-control">
                        <?php $__currentLoopData = $postulantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $postulante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($postulante->id_postulante); ?>"><?php echo e($postulante->nombres); ?> <?php echo e($postulante->apellidos); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label>Plan de Estudio</label>
                    <select name="plan_estudio_id" id="edit_plan" class="form-control">
                        <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label>Periodo</label>
                    <select name="periodo_id" id="edit_periodo" class="form-control">
                        <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($periodo->id); ?>"><?php echo e($periodo->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label>Semestre</label>
                    <select name="semestre_id" id="edit_semestre" class="form-control">
                        <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($semestre->id); ?>"><?php echo e($semestre->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label>Estado</label>
                    <select name="estado" id="edit_estado" class="form-control">
                        <option value="Matriculado">Matriculado</option>
                        <option value="Pendiente">Pendiente</option>
                        <option value="Retirado">Retirado</option>
                        <option value="Convalidado">Convalidado</option>
                        <option value="Repitencia">Repitencia</option>
                    </select>
                </div>
                <div class="mb-2">
                    <label>Fecha Matrícula</label>
                    <input type="date" name="fecha_matricula" id="edit_fecha" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Actualizar</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </form>
  </div>
</div>


<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



<script>
    $(document).ready(function () {
        $('#filtroMatriculas').on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                url: $(this).attr('action'),
                method: 'GET',
                data: $(this).serialize(),
                success: function (response) {
                    $('#tablaMatriculas').html(response);

                    // 💡 Volver a inicializar DataTable en la tabla recién insertada
                    inicializarDataTable();
                },
                error: function () {
                    alert('Ocurrió un error al filtrar las matrículas.');
                }
            });
        });

        // ✅ Inicializar DataTable al cargar la página
        inicializarDataTable();
    });

    function inicializarDataTable() {
        // Destruye si ya existe una instancia anterior
        if ($.fn.DataTable.isDataTable('#tablaPeriodos')) {
            $('#tablaPeriodos').DataTable().destroy();
        }

        // Inicializa DataTable nuevamente
        $('#tablaPeriodos').DataTable({
            responsive: true,
            lengthChange: true,
            autoWidth: false,
            buttons: [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Matriculas' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            paging: true,
            searching: true,
            info: true,
            language: {
                search: "Buscar:",
                lengthMenu: "Mostrar _MENU_ registros por página",
                info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                paginate: {
                    first: "Primero",
                    previous: "Anterior",
                    next: "Siguiente",
                    last: "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    }
</script>



<script>
$(document).ready(function () {
    // Capturar el envío del formulario
    $('#formEditarMatricula').submit(function (e) {
        e.preventDefault();

        let form = $(this);
        let url = form.attr('action');
        let formData = form.serialize();

        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('input[name="_token"]').val()
            },
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Actualizado correctamente',
                    showConfirmButton: false,
                    timer: 1500
                });

                $('#editModal').modal('hide');

                // Opcional: recargar tabla vía AJAX o recargar página
                location.reload();
            },
            error: function (xhr) {
                let errores = xhr.responseJSON?.errors;
                let mensaje = 'Ocurrió un error al actualizar.';

                if (errores) {
                    mensaje = Object.values(errores).flat().join('<br>');
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: mensaje
                });
            }
        });
    });

    // Cuando haces clic en el botón de edición, se llena el formulario
    $('.btn-editar-matricula').on('click', function () {
        const id = $(this).data('id');
        $('#formEditarMatricula').attr('action', '/matriculas/' + id);

        $('#edit_id').val(id);
        $('#edit_codigo').val($(this).data('codigo'));
        $('#edit_postulante').val($(this).data('postulante'));
        $('#edit_plan').val($(this).data('plan'));
        $('#edit_periodo').val($(this).data('periodo'));
        $('#edit_semestre').val($(this).data('semestre'));
        $('#edit_estado').val($(this).data('estado'));
        $('#edit_fecha').val($(this).data('fecha'));
    });
});
</script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcarhuaz.dedu.pe/resources/views/matriculas/index.blade.php ENDPATH**/ ?>