<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Asistencia</title>
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }

        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }

        .info-table {
            margin-top: 20px;
            width: 100%;
        }

        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }

        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }

        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }

        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }

        .promedio {
            font-weight: bold;
            color: #007bff;
        }

        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" class="logo-img">
        <h2>Reporte de Asistencia</h2>
    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Institución</strong></td>
                <td><?php echo e($instituto->nombre); ?></td>
                <td><strong>DRE</strong></td>
                <td><?php echo e($instituto->dre); ?></td>
            </tr>
            <tr>
                <td><strong>Dirección</strong></td>
                <td><?php echo e($instituto->direccion); ?></td>
                <td><strong>Teléfono</strong></td>
                <td><?php echo e($instituto->telefono); ?></td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td><?php echo e($instituto->codigo_modular); ?></td>
                <td><strong>Fecha de Emisión</strong></td>
                <td><?php echo e(now()->format('d/m/Y')); ?></td>
            </tr>
            <tr>
                <td><strong>Programa de Estudio</strong></td>
                <td><?php echo e($curso_info['programa']); ?></td>
                <td><strong>Periodo Lectivo</strong></td>
                <td><?php echo e($curso_info['periodo']); ?></td>
            </tr>
            <tr>
                <td><strong>Semestre Académico</strong></td>
                <td><?php echo e($curso_info['semestre']); ?></td>
                <td><strong>Docente</strong></td>
                <td><?php echo e($curso_info['docente']); ?></td>
            </tr>
        </tbody>
    </table>

    <table class="table table-bordered table-striped info-table">
        <thead>
            <tr>
                <th>N°</th>
                <th>Estudiante</th>
                <th>DNI</th>
                <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($loop->iteration); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <th>P</th>
                <th>F</th>
                <th>J</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $matriculados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $mat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($i + 1); ?></td>
                    <td style="text-align: left;"><?php echo e($mat->nombre); ?></td>
                    <td><?php echo e($mat->dni); ?></td>
                    <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td><?php echo e($mat->asistencias_por_sesion[$sesion->id_sesion] ?? 'P'); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <td><?php echo e($mat->totalP); ?></td>
                    <td><?php echo e($mat->totalF); ?></td>
                    <td><?php echo e($mat->totalJ); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/asistencias/reporte_pdf.blade.php ENDPATH**/ ?>