<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Horario extends Model
{
    use HasFactory;

    protected $table = 'horarios';

    protected $fillable = [
        'id_docente',
        'id_curso',
        'hora_inicio',
        'hora_fin',
        'dia',
        'tipo_aula',
        'numero_aula',
        'id_periodo',
        'frecuencia',
        'capacidad',
        'id_plan_estudio','id_seccion','id_turno','id_aula'
    ];

    public function docente()
    {
        return $this->belongsTo(Docente::class, 'id_docente');
    }

    public function curso()
    {
        return $this->belongsTo(Curso::class, 'id_curso');
    }

    public function periodo()
    {
        return $this->belongsTo(Periodo::class, 'id_periodo');
    }

    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'id_plan_estudio');
    }
    
    public function seccion()
    {
        return $this->belongsTo(Seccion::class, 'id_seccion');
    }

    public function turno()
    {
        return $this->belongsTo(Turno::class, 'id_turno');
    }

    public function aula()
{
    return $this->belongsTo(Aula::class, 'id_aula');
}


}
