<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Procesos de Admision <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                    <a href="<?php echo e(route('admisiones.create')); ?>" 
                        class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                        data-bs-toggle="tooltip" data-bs-placement="right" title="Crear nuevo proceso de admisión">
                        <i class="fas fa-plus"></i> Agregar Proceso de Admisión
                    </a>


                <div class="table-responsive">
                    <table id="tablaAdmisiones" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Periodo</th>
                                <th>Tipo Adm.</th>
                                <th>Inicio Proceso</th>
                                <th>Fin Proceso</th>
                                <th>Fecha Examen</th>
                                <th>Dirección</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $admisiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($admision->id_admision); ?></td>
                                    <td><?php echo e($admision->nombre); ?></td>
                                    <td><?php echo e($admision->periodo->nombre ?? '—'); ?></td>
                                    <td><?php echo e($admision->tipoAdmision->nombre ?? '—'); ?></td>
                                    <td><?php echo e($admision->inicio_proceso); ?></td>
                                    <td><?php echo e($admision->fin_proceso); ?></td>
                                    <td><?php echo e($admision->fecha_examen); ?></td>
                                    <td><?php echo e($admision->direccion); ?></td>
                                    <td >

                                        <!-- Editar -->
                                        <a href="#"
                                            class="text-warning btn-editar-admision"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarAdmision"
                                            data-id="<?php echo e($admision->id_admision); ?>"
                                            data-nombre="<?php echo e($admision->nombre); ?>"
                                            data-id_periodo="<?php echo e($admision->id_periodo); ?>"
                                            data-id_tipo_admision="<?php echo e($admision->id_tipo_admision); ?>"
                                            data-inicio_proceso="<?php echo e($admision->inicio_proceso); ?>"
                                            data-fin_proceso="<?php echo e($admision->fin_proceso); ?>"
                                            data-inicio_inscripciones="<?php echo e($admision->inicio_inscripciones); ?>"
                                            data-fin_inscripciones="<?php echo e($admision->fin_inscripciones); ?>"
                                            data-inicio_extemporaneo="<?php echo e($admision->inicio_extemporaneo); ?>"
                                            data-fin_extemporaneo="<?php echo e($admision->fin_extemporaneo); ?>"
                                            data-fecha_examen="<?php echo e($admision->fecha_examen); ?>"
                                            data-direccion="<?php echo e($admision->direccion); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <!-- Eliminar -->
                                        <button type="button"
                                            class="btn btn-link p-0 m-0 delete-button"
                                            data-id="<?php echo e($admision->id_admision); ?>">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </button>

                                        <form id="form-delete-<?php echo e($admision->id_admision); ?>"
                                            action="<?php echo e(route('admisiones.destroy', $admision->id_admision)); ?>"
                                            method="POST" class="d-none">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>


            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal Editar Admisión -->
<div class="modal fade" id="modalEditarAdmision" tabindex="-1" aria-labelledby="modalEditarAdmisionLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <form id="form-editar-admision">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarAdmisionLabel">
                        <i class="mdi mdi-pencil-outline me-1"></i> Editar Proceso de Admisión
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <div class="modal-body">
                    
                    <div class="card mb-3">
                        
                        <div class="card-body row g-3">
                            <input type="hidden" name="id_admision" id="edit_id_admision">

                            <div class="col-md-6">
                                <label for="edit_nombre" class="form-label">Nombre del Proceso</label>
                                <input type="text" class="form-control" name="nombre" id="edit_nombre" required>
                            </div>

                            <div class="col-md-6">
                                <label for="edit_direccion" class="form-label">Dirección</label>
                                <input type="text" class="form-control" name="direccion" id="edit_direccion">
                            </div>

                            <div class="col-md-6">
                                <label for="edit_id_periodo" class="form-label">Periodo</label>
                                <select name="id_periodo" id="edit_id_periodo" class="form-select" required>
                                    <option value="">Seleccione</option>
                                    <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($periodo->id); ?>"><?php echo e($periodo->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label for="edit_id_tipo_admision" class="form-label">Tipo de Admisión</label>
                                <select name="id_tipo_admision" id="edit_id_tipo_admision" class="form-select" required>
                                    <option value="">Seleccione</option>
                                    <?php $__currentLoopData = $tiposAdmision; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tipo->id_tipo_admision); ?>"><?php echo e($tipo->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    
                    <div class="card mb-3">
                        <div class="card-header">
                            <h6 class="mb-0">Fechas del Proceso</h6>
                        </div>
                        <div class="card-body row g-3">
                            <?php
                                $fechas = [
                                    'inicio_proceso' => 'Inicio del Proceso',
                                    'fin_proceso' => 'Fin del Proceso',
                                    'inicio_inscripciones' => 'Inicio de Inscripciones',
                                    'fin_inscripciones' => 'Fin de Inscripciones',
                                    'inicio_extemporaneo' => 'Inicio Extemporáneo',
                                    'fin_extemporaneo' => 'Fin Extemporáneo',
                                    'fecha_examen' => 'Fecha de Examen',
                                ];
                            ?>

                            <?php $__currentLoopData = $fechas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <label for="edit_<?php echo e($name); ?>" class="form-label"><?php echo e($label); ?></label>
                                    <input type="date" class="form-control" name="<?php echo e($name); ?>" id="edit_<?php echo e($name); ?>">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>


                    
                    <div class="accordion" id="accordionOpciones">
                        
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingRequisitos">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRequisitos" aria-expanded="false">
                                    Requisitos del Proceso
                                </button>
                            </h2>
                            <div id="collapseRequisitos" class="accordion-collapse collapse" data-bs-parent="#accordionOpciones">
                                <div class="accordion-body row g-2">
                                    <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check col-md-6">
                                            <input class="form-check-input" type="checkbox"
                                                name="requisitos[]" value="<?php echo e($requisito->id_requisito); ?>"
                                                id="edit_requisito_<?php echo e($requisito->id_requisito); ?>">
                                            <label class="form-check-label" for="edit_requisito_<?php echo e($requisito->id_requisito); ?>">
                                                <?php echo e($requisito->nombre); ?>

                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingPagos">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePagos" aria-expanded="false">
                                    Tipos de Pago Permitidos
                                </button>
                            </h2>
                            <div id="collapsePagos" class="accordion-collapse collapse" data-bs-parent="#accordionOpciones">
                                <div class="accordion-body row g-2">
                                    <?php $__currentLoopData = $tiposPago; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check col-md-6">
                                            <input class="form-check-input" type="checkbox"
                                                name="tipos_pago[]" value="<?php echo e($pago->id_tipo_pago); ?>"
                                                id="edit_pago_<?php echo e($pago->id_tipo_pago); ?>">
                                            <label class="form-check-label" for="edit_pago_<?php echo e($pago->id_tipo_pago); ?>">
                                                <?php echo e($pago->nombre); ?>

                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="mdi mdi-content-save-edit-outline me-1"></i> Guardar Cambios
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="mdi mdi-close-circle-outline me-1"></i> Cancelar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>







<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaAdmisiones").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaAdmisiones_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        // Abrir modal y cargar datos
        $('.btn-editar-admision').on('click', function () {
            const id = $(this).data('id');

            // Llamada AJAX para obtener los datos del proceso
            $.get(`/admisiones/${id}/edit`, function (data) {
                const admision = data.admision;

                // Llenar campos del formulario
                $('#edit_id_admision').val(admision.id_admision);
                $('#edit_nombre').val(admision.nombre);
                $('#edit_direccion').val(admision.direccion);
                $('#edit_id_periodo').val(admision.id_periodo);
                $('#edit_id_tipo_admision').val(admision.id_tipo_admision);

                $('#edit_inicio_proceso').val(admision.inicio_proceso);
                $('#edit_fin_proceso').val(admision.fin_proceso);
                $('#edit_inicio_inscripciones').val(admision.inicio_inscripciones);
                $('#edit_fin_inscripciones').val(admision.fin_inscripciones);
                $('#edit_inicio_extemporaneo').val(admision.inicio_extemporaneo);
                $('#edit_fin_extemporaneo').val(admision.fin_extemporaneo);
                $('#edit_fecha_examen').val(admision.fecha_examen);

                // Limpiar todos los checkboxes
                $('input[name="requisitos[]"]').prop('checked', false);
                $('input[name="tipos_pago[]"]').prop('checked', false);

                // Marcar los requisitos relacionados
                admision.requisitos.forEach(function(requisito) {
                    $('#edit_requisito_' + requisito.id_requisito).prop('checked', true);
                });

                // Marcar los tipos de pago relacionados
                admision.tipos_pago.forEach(function(tipoPago) {
                    $('#edit_pago_' + tipoPago.id_tipo_pago).prop('checked', true);
                });

                // Mostrar modal
                $('#modalEditarAdmision').modal('show');
            });
        });

        // Enviar formulario por AJAX
        $('#form-editar-admision').on('submit', function (e) {
            e.preventDefault();

            const id = $('#edit_id_admision').val();
            const formData = $(this).serialize();

            $.ajax({
                url: `/admisiones/${id}`,
                method: 'POST', // Laravel espera POST con _method=PUT
                data: formData,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Actualizado',
                        text: response.success,
                        showConfirmButton: true
                    }).then(() => {
                        // Recargar la página solo después de que se cierre el alert
                        location.reload();
                    });
                },
                error: function (xhr) {
                    let mensaje = 'Ocurrió un error al actualizar.';
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        mensaje = Object.values(xhr.responseJSON.errors).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>


<script>
    $(document).on('click', '.delete-button', function () {
    const admisionId = $(this).data('id');

    Swal.fire({
        title: '¿Estás seguro?',
        text: "Este proceso y sus relaciones serán eliminados.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admisiones/${admisionId}`,
                type: 'POST',
                data: {
                    _method: 'DELETE',
                    _token: $('meta[name="csrf-token"]').attr('content'),
                },
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Eliminado',
                        text: response.success,
                        timer: 2500,
                        showConfirmButton: false
                    }).then(() => {
                        // Opcional: si usas DataTables
                        // $('#tabla-admision').DataTable().ajax.reload();

                        // Recarga la página
                        location.reload();
                    });
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'No se pudo eliminar el proceso. Intenta nuevamente.'
                    });
                }
            });
        }
    });
});

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/admisiones/index.blade.php ENDPATH**/ ?>