<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Plan de Estudio <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoPlanEstudio">
                    <i class="fas fa-plus"></i> Agregar Nuevo Plan de Estudio
                </button>
                <div class="table-responsive">
                    <table id="tablaPlanesEstudio" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Código</th>
                                <th>Resolución</th>
                                <th>Tipo</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planEstudio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($planEstudio->id); ?></td>
                                    <td><?php echo e($planEstudio->nombre); ?></td>
                                    <td><?php echo e($planEstudio->codigo); ?></td>
                                    <td><?php echo e($planEstudio->resolucion); ?></td>
                                    <td><?php echo e($planEstudio->tipo); ?></td>
                                    <td>
                                        <?php if($planEstudio->activo): ?>
                                            <span class="badge badge-soft-success">Activo</span>
                                        <?php else: ?>
                                            <span class="badge badge-soft-warning">Inactivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <!-- Icono de editar -->
                                        <a href="#" 
                                            class="text-warning"
                                            data-bs-toggle="modal" 
                                            data-bs-target="#editModal"
                                            data-id="<?php echo e($planEstudio->id); ?>"
                                            data-nombre="<?php echo e($planEstudio->nombre); ?>"
                                            data-codigo="<?php echo e($planEstudio->codigo); ?>"
                                            data-resolucion="<?php echo e($planEstudio->resolucion); ?>"
                                            data-tipo="<?php echo e($planEstudio->tipo); ?>"
                                            data-activo="<?php echo e($planEstudio->activo); ?>"
                                            data-descripcion="<?php echo e($planEstudio->descripcion); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <form action="#" method="POST" style="display:inline;" class="form-eliminar" data-id="<?php echo e($planEstudio->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <a href="#" class="text-danger btn-eliminar">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </a>
                                        </form>

                                        
                                        

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para agregar un nuevo Plan de Estudio -->
<div class="modal fade" id="modalNuevoPlanEstudio" tabindex="-1" aria-labelledby="modalNuevoPlanEstudioLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevoPlanEstudioLabel">Agregar Nuevo Plan de Estudio</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <!-- Formulario para crear el nuevo Plan de Estudio -->
                <form id="formNuevoPlanEstudio">
                    <?php echo csrf_field(); ?>

                    <!-- Campo Nombre Plan de Estudio -->
                    <div class="mb-3">
                        <label for="nombrePlanEstudio" class="form-label">Nombre del Plan de Estudio</label>
                        <input type="text" class="form-control" id="nombrePlanEstudio" name="nombre" required>
                    </div>

                    <!-- Campo Descripción -->
                    <div class="mb-3">
                        <label for="descripcionPlanEstudio" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcionPlanEstudio" name="descripcion" rows="3"></textarea>
                    </div>

                    <!-- Campo Código -->
                    <div class="mb-3">
                        <label for="codigoPlanEstudio" class="form-label">Código</label>
                        <input type="text" class="form-control" id="codigoPlanEstudio" name="codigo" required>
                    </div>

                    <!-- Campo Resolución -->
                    <div class="mb-3">
                        <label for="resolucionPlanEstudio" class="form-label">Resolución</label>
                        <input type="text" class="form-control" id="resolucionPlanEstudio" name="resolucion" required>
                    </div>

                    <!-- Campo Tipo -->
                    <div class="mb-3">
                        <label for="tipoPlanEstudio" class="form-label">Tipo</label>
                        <select class="form-select" id="tipoPlanEstudio" name="tipo" required>
                            <option value="">-- Seleccionar --</option>
                            <option value="Modular">Modular</option>
                            <option value="Transversal">Transversal</option>
                            <option value="Empleabilidad">Empleabilidad</option>
                        </select>
                    </div>

                    <!-- Campo Activo -->
                    <div class="mb-3">
                        <label for="activo" class="form-label">Estado</label>
                        <select class="form-select" id="activo" name="activo" required>
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-de-primary btn-sm px-4">Guardar Plan de Estudio</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<!-- Modal de edición -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Editar Plan de Estudio</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <!-- Campos de edición -->
                    <input type="hidden" id="editId" name="id">
                    
                    <div class="mb-3">
                        <label for="editNombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="editNombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="editCodigo" class="form-label">Código</label>
                        <input type="text" class="form-control" id="editCodigo" name="codigo" required>
                    </div>

                    <div class="mb-3">
                        <label for="editResolucion" class="form-label">Resolución</label>
                        <input type="text" class="form-control" id="editResolucion" name="resolucion">
                    </div>

                    <div class="mb-3">
                        <label for="editTipo" class="form-label">Tipo</label>
                        <select class="form-control" id="editTipo" name="tipo" required>
                            <option value="Modular">Modular</option>
                            <option value="transversal">Transversal</option>
                            <option value="empleabilidad">Empleabilidad</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="editDescripcion" class="form-label">Descripción</label>
                        <textarea class="form-control" id="editDescripcion" name="descripcion"></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="editActivo" class="form-label">Estado</label>
                        <select class="form-control" id="editActivo" name="activo">
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">Actualizar</button>
                </form>
            </div>
        </div>
    </div>
</div>



<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPlanesEstudio").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPlanesEstudio_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function() {
        $('#formNuevoPlanEstudio').on('submit', function(e) {
            e.preventDefault(); // Evitar que el formulario se envíe de manera tradicional

            // Obtener los datos del formulario
            var formData = $(this).serialize();

            // Enviar la solicitud AJAX
            $.ajax({
                url: '<?php echo e(route('planes_estudio.store')); ?>', // Asegúrate de que la ruta sea correcta
                type: 'POST',
                data: formData,
                success: function(response) {
                    // Si la respuesta es exitosa, muestra la alerta
                    Swal.fire({
                        icon: 'success',
                        title: '¡Plan de Estudio creado!',
                        text: response.message, // Aquí puedes personalizar el mensaje de éxito
                        showConfirmButton: true,
                    }).then(() => {
                        // Cierra el modal y actualiza la página
                        $('#modalNuevoPlanEstudio').modal('hide');
                        location.reload(); // O puedes actualizar la vista de alguna otra forma
                    });
                },
                error: function(xhr, status, error) {
                    // Si ocurre un error, muestra una alerta de error
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Hubo un error al crear el plan de estudio. Por favor, intentalo de nuevo.',
                        showConfirmButton: true,
                    });
                }
            });
        });
    });

</script>

<script>
    // Llenar el modal con los datos del plan de estudio
    $('#editModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Botón que abrió el modal
        var id = button.data('id');
        var nombre = button.data('nombre');
        var codigo = button.data('codigo');
        var resolucion = button.data('resolucion');
        var tipo = button.data('tipo');
        var descripcion = button.data('descripcion');
        var activo = button.data('activo');

        // Rellenar el formulario con los valores
        $('#editId').val(id);
        $('#editNombre').val(nombre);
        $('#editCodigo').val(codigo);
        $('#editResolucion').val(resolucion);
        $('#editTipo').val(tipo);
        $('#editDescripcion').val(descripcion);
        $('#editActivo').val(activo);
    });

    // Enviar la actualización a través de AJAX
    $('#editForm').on('submit', function (e) {
        e.preventDefault();
        
        var id = $('#editId').val();
        var formData = $(this).serialize();

        $.ajax({
            url: '/planes_estudio/' + id,  // Ruta con el ID
            method: 'PUT',
            data: formData,
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: '¡Actualizado!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false,
                });

                $('#editModal').modal('hide');

                setTimeout(function () {
                    location.reload();
                }, 2100);
            },
            error: function (xhr) {
                let errores = xhr.responseJSON.errors;
                let mensajes = '';

                for (let campo in errores) {
                    mensajes += errores[campo][0] + '<br>';
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error al actualizar',
                    html: mensajes,
                });
            }
        });
    });
</script>

<script>
    // Eliminar plan de estudio con AJAX
    $('.btn-eliminar').on('click', function (e) {
        e.preventDefault();

        var form = $(this).closest('form');
        var planId = form.data('id');

        Swal.fire({
            title: '¿Estás seguro de eliminar este plan de estudio?',
            text: "¡Esta acción no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/planes_estudio/' + planId,
                    method: 'DELETE',
                    data: form.serialize(),
                    success: function (response) {
                        Swal.fire(
                            'Eliminado!',
                            'El plan de estudio ha sido eliminado.',
                            'success'
                        );
                        setTimeout(function () {
                            location.reload(); // Recarga la página después de la eliminación
                        }, 1500);
                    },
                    error: function () {
                        Swal.fire(
                            'Error!',
                            'Hubo un problema al eliminar el plan de estudio.',
                            'error'
                        );
                    }
                });
            }
        });
    });

    
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpcopacabanallapo.dedu.pe/resources/views/planes_estudio/index.blade.php ENDPATH**/ ?>