<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PlanEstudio;
use App\Models\Periodo;
class PlanEstudioPeriodoController extends Controller
{
    //

    public function index()
{
    $planes = PlanEstudio::with('periodos')->get(); // Opcional: eager loading
    $periodos = Periodo::all(); // Cargamos todos los periodos disponibles
    return view('planes_estudio.listar_para_asociar', compact('planes', 'periodos'));
}

    public function edit($id)
{
    $plan = PlanEstudio::findOrFail($id);
    $periodos = Periodo::all();
    $periodosSeleccionados = $plan->periodos->pluck('id')->toArray();

    return view('planes_estudio.asociar_periodos', compact('plan', 'periodos', 'periodosSeleccionados'));
}

public function update(Request $request, $id)
{
    $plan = PlanEstudio::findOrFail($id);
    $plan->periodos()->sync($request->input('periodos', [])); // sincroniza los seleccionados

    return redirect()->route('planes_estudio.index')->with('success', 'Periodos actualizados correctamente');
}

public function asociarPeriodos(Request $request, $id)
{
    // Validar que al menos un periodo sea seleccionado
    $request->validate([
        'periodos' => 'required|array|min:1',
        'periodos.*' => 'exists:periodos,id', // Verifica que los IDs sean válidos
    ]);

    $planEstudio = PlanEstudio::findOrFail($id);
    
    // Sincronizamos los periodos seleccionados (asociar/desasociar)
    $planEstudio->periodos()->sync($request->periodos);

    return redirect()->route('planes_estudio.index')->with('success', 'Periodos actualizados correctamente.');
}

public function show(string $id)
{
    //
}



}
