@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Gestión de Asistencia - {{ $curso->nombre }} @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

                <div class="mb-3 text-end">
                    <a href="{{ route('docente.cursos.informacion', $curso->id) }}" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>

                    <a href="{{ route('docente.asistencia.reporte.pdf', $curso->id) }}" target="_blank" class="btn btn-primary btn-sm">
                        <i class="fas fa-file-pdf"></i> Reporte Asistencia
                    </a>
                </div>

                
                <div class="table-responsive">
                    
                    @if($sesiones->isEmpty())
                        <div class="alert alert-warning">
                            No hay sesiones activas para este curso.
                        </div>
                    @else
                        {{-- Formulario para marcar asistencia --}}
                        <form id="formAsistencia" method="POST">
                            @csrf
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Estudiante</th>
                                        @foreach($sesiones as $sesion)
                                            <th>{{ $sesion->nombre }}</th>
                                        @endforeach
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- Listar estudiantes matriculados --}}
                                    @foreach($matriculados as $matriculaCurso)
                                        <tr>
                                            <td>{{ $matriculaCurso->nombre }}</td>

                                            {{-- Generar una celda por cada sesión --}}
                                            @foreach($sesiones as $sesion)
                                                @php
                                                    // Buscar la asistencia para esta sesión
                                                    $asistencia = $matriculaCurso->asistencias_por_sesion[$sesion->id_sesion] ?? null;
                                                    $estado = $asistencia ? $asistencia['estado'] : 'P';
                                                    $observacion = $asistencia ? $asistencia['observaciones'] : '';
                                                @endphp

                                                <td>
                                                    {{-- Selector de estado --}}
                                                    <select name="asistencias[{{ $matriculaCurso->matricula_curso_id }}][{{ $sesion->id_sesion }}]" class="form-control form-control-sm">
                                                        <option value="P" {{ $estado == 'P' ? 'selected' : '' }}>P</option>
                                                        <option value="F" {{ $estado == 'F' ? 'selected' : '' }}>F</option>
                                                        <option value="J" {{ $estado == 'J' ? 'selected' : '' }}>J</option>
                                                    </select>

                                                    {{-- Input para observaciones --}}
                                                    <input 
                                                        type="text" 
                                                        class="form-control form-control-sm" 
                                                        name="observaciones[{{ $matriculaCurso->matricula_curso_id }}][{{ $sesion->id_sesion }}]" 
                                                        placeholder="Observaciones"
                                                        value="{{ $observacion }}"
                                                    >
                                                </td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            {{-- Botón de enviar --}}
                            <div class="text-center mt-3">
                                <button type="submit" class="btn btn-success">Guardar Asistencia</button>
                            </div>
                        </form>


                    @endif



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal: Nuevo Semestre -->





<!-- Modal de Edición -->






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
            $(document).ready(function () {
                $("#tablaSemestres").DataTable({
                    "responsive": true,
                    "lengthChange": true,
                    "autoWidth": false,
                    "buttons": [
                        {
                            extend: 'collection',
                            text: 'Opciones',
                            buttons: [
                                { extend: 'copy', text: 'Copiar' },
                                { extend: 'csv', text: 'CSV' },
                                { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                                { extend: 'pdf', text: 'PDF' },
                                { extend: 'print', text: 'Imprimir' }
                            ]
                        },
                        { extend: 'colvis', text: 'Visibilidad de Columna' }
                    ],
                    "paging": true,
                    "searching": true,
                    "info": true,
                    "language": {
                        "search": "Buscar:",
                        "lengthMenu": "Mostrar _MENU_ registros por página",
                        "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                        "paginate": {
                            "first": "Primero",
                            "previous": "Anterior",
                            "next": "Siguiente",
                            "last": "Último"
                        }
                    }
                }).buttons().container().appendTo('#tablaSemestres_wrapper .col-md-6:eq(0)');
            });
    </script>

<script>
document.getElementById('formAsistencia').addEventListener('submit', function(e) {
    e.preventDefault();

    let form = this;
    let asistencias = {};
    let observaciones = {};

    // Recorrer los selects de asistencias
    form.querySelectorAll('select[name^="asistencias"]').forEach(select => {
        const nameParts = select.name.match(/asistencias\[(\d+)\]\[(\d+)\]/);
        if (nameParts) {
            const matriculaCursoId = nameParts[1];
            const sesionId = nameParts[2];

            if (!asistencias[matriculaCursoId]) {
                asistencias[matriculaCursoId] = {};
            }

            asistencias[matriculaCursoId][sesionId] = select.value;
        }
    });

    // Recorrer los inputs de observaciones
    form.querySelectorAll('input[name^="observaciones"]').forEach(input => {
        const nameParts = input.name.match(/observaciones\[(\d+)\]\[(\d+)\]/);
        if (nameParts) {
            const matriculaCursoId = nameParts[1];
            const sesionId = nameParts[2];

            if (!observaciones[matriculaCursoId]) {
                observaciones[matriculaCursoId] = {};
            }

            observaciones[matriculaCursoId][sesionId] = input.value;
        }
    });

    // 🔥 Agregamos console.log para VER que se está enviando 🔥
    console.log("Asistencias preparadas:", asistencias);
    console.log("Observaciones preparadas:", observaciones);

    fetch("{{ route('docente.asistencia.store', $curso->id) }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            asistencias: asistencias,
            observaciones: observaciones
        })
    })
    .then(response => response.json())
    .then(data => {
        console.log("Respuesta del servidor:", data); // 🔥 también aquí
        if(data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: data.message,
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                //location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message,
            });
        }
    })
    .catch(error => {
        console.error('Error en fetch:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No se pudo registrar la asistencia.'
        });
    });
});
</script>






@endsection
