@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Horario @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

                <form id="filtro-docente" method="GET">
                    @csrf
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="id_periodo" class="form-label">Periodo</label>
                            <select name="id_periodo" id="id_periodo" class="form-select" required>
                                <option value="">-- Seleccionar periodo --</option>
                                @foreach($periodos as $periodo)
                                    <option value="{{ $periodo->id }}">{{ $periodo->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="id_docente" class="form-label">Docente</label>
                            <select name="id_docente" id="id_docente" class="form-select" required>
                                <option value="">-- Seleccionar docente --</option>
                            </select>
                        </div>
                    </div>

                    
                </form>

                  <!-- Botón para abrir el modal de nuevo horario -->
                
           
                <div class="table-responsive">
                    <!-- Filtro de búsqueda para el docente -->

                    <div class="mb-3 text-end">
                        <button type="button" class="btn btn-success d-none" id="btnMostrarModal" data-bs-toggle="modal" data-bs-target="#modalCrearHorario">
                            <i class="fas fa-plus"></i> Registrar horario
                        </button>
                    </div>


                    <!-- Tabla para mostrar los horarios -->
                    <table id="tabla-horarios" class="table table-striped mt-4" style="display:none;">
                        <thead>
                            <tr>
                                <th>Curso</th>
                                <th>Hora inicio</th>
                                <th>Hora fin</th>
                                <th>Día</th>
                                <th>Aula</th>
                                <th>Frecuencia</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Aquí se cargarán los horarios de acuerdo al filtro -->
                        </tbody>
                    </table>


                
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!-- Modal para registrar horario -->
<div class="modal fade" id="modalCrearHorario" tabindex="-1" aria-labelledby="modalCrearHorarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <form id="formCrearHorario" method="POST" action="{{ route('horarios.store') }}">
            @csrf
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="modalCrearHorarioLabel">
                        <i class="fas fa-calendar-plus me-2"></i>Registrar Horario
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <div class="modal-body">
                    <!-- Campos ocultos -->
                    <input type="hidden" name="id_periodo" id="inputPeriodoId">
                    <input type="hidden" name="id_docente" id="inputDocenteId">

                    <div class="row">
                        <!-- Información general -->
                        <div class="col-12">
                            <div class="card mb-3">
                                <div class="card-header bg-light">
                                    <strong><i class="fas fa-info-circle me-1"></i>Información básica</strong>
                                </div>
                                <div class="card-body row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Periodo</label>
                                        <input type="text" class="form-control" id="inputPeriodoNombre" disabled>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Docente</label>
                                        <input type="text" class="form-control" id="inputDocenteNombre" disabled>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Plan de estudio</label>
                                        <select name="id_plan_estudio" id="selectPlanEstudio" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                        </select>

                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Curso</label>
                                        <select name="id_curso" id="selectCurso" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- Horario -->
                        <div class="col-12">
                            <div class="card mb-3">
                                <div class="card-header bg-light">
                                    <strong><i class="fas fa-clock me-1"></i>Datos del horario</strong>
                                </div>
                                <div class="card-body row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Hora inicio</label>
                                        <input type="time" name="hora_inicio" class="form-control" required>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Hora fin</label>
                                        <input type="time" name="hora_fin" class="form-control" required>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Día</label>
                                        <select name="dia" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                            <option>Lunes</option>
                                            <option>Martes</option>
                                            <option>Miércoles</option>
                                            <option>Jueves</option>
                                            <option>Viernes</option>
                                            <option>Sábado</option>
                                            <option>Domingo</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Aula y frecuencia -->
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <strong><i class="fas fa-school me-1"></i>Pabellón, Aula, Turno, Sección y Frecuencia</strong>
                                </div>

                                <div class="card-body row">

                                    <!-- PABELLÓN -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Pabellón</label>
                                        <select name="id_pabellon" id="selectPabellon" class="form-select" required>
                                            <option value="">-- Seleccionar Pabellón --</option>
                                            @foreach($pabellones as $p)
                                                <option value="{{ $p->id }}">{{ $p->nombre }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- AULA -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Aula</label>
                                        <select name="id_aula" id="selectAula" class="form-select" required>
                                            <option value="">-- Selecciona primero un pabellón --</option>
                                        </select>
                                    </div>

                                    <!-- INFO AULA (AUTO CARGADO) -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Tipo Aula</label>
                                        <input type="text" id="info_tipo" class="form-control" readonly>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Número Aula</label>
                                        <input type="text" id="info_numero" class="form-control" readonly>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Capacidad</label>
                                        <input type="text" id="info_capacidad" class="form-control" readonly>
                                    </div>

                                    <!-- FRECUENCIA -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Frecuencia</label>
                                        <select name="frecuencia" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                            <option value="Semanal">Semanal</option>
                                            <option value="Quincenal">Quincenal</option>
                                            <option value="Mensual">Mensual</option>
                                        </select>
                                    </div>

                                    <!-- TURNO -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Turno</label>
                                        <select name="id_turno" id="selectTurno" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                            @foreach($turnos as $turno)
                                                <option value="{{ $turno->id }}">{{ $turno->nombre }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- SECCIÓN -->
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Sección</label>
                                        <select name="id_seccion" id="selectSeccion" class="form-select" required>
                                            <option value="">-- Seleccionar --</option>
                                            @foreach($secciones as $seccion)
                                                <option value="{{ $seccion->id }}">{{ $seccion->nombre }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                </div>
                            </div>
                        </div>



                    </div> <!-- row -->
                </div>

                <div class="modal-footer bg-light">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-1"></i>Guardar horario
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Cancelar
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaCursos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaCursos_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const periodoSelect = document.getElementById('id_periodo');
        const docenteSelect = document.getElementById('id_docente');
        const tablaHorarios = document.getElementById('tabla-horarios');
        const tablaBody = tablaHorarios.querySelector('tbody');

        

        // Función para cargar horarios
        function cargarHorarios() {
            const periodoId = periodoSelect.value;
            const docenteId = docenteSelect.value;
            const btnMostrarModal = document.getElementById('btnMostrarModal');

            if (periodoId && docenteId) {
                fetch(`/horarios/por-docente-periodo/${docenteId}/${periodoId}`)
                    .then(res => res.json())
                    .then(data => {
                        tablaBody.innerHTML = '';

                        if (data.length > 0) {
                            data.forEach(horario => {
                                const row = document.createElement('tr');
                                row.innerHTML = `
                                    <td>${horario.curso.nombre}</td>
                                    <td>${horario.hora_inicio}</td>
                                    <td>${horario.hora_fin}</td>
                                    <td>${horario.dia}</td>
                                    <td>${horario.numero_aula}</td>
                                    <td>${horario.frecuencia}</td>
                                `;
                                tablaBody.appendChild(row);
                            });
                        } else {
                            tablaBody.innerHTML = `
                                <tr>
                                    <td colspan="6" class="text-center">No hay horarios registrados para este docente en el periodo seleccionado.</td>
                                </tr>
                            `;
                        }

                        tablaHorarios.style.display = 'table';
                        btnMostrarModal.classList.remove('d-none'); // Mostrar botón
                    })
                    .catch(error => {
                        console.error('Error al cargar los horarios:', error);
                        alert('Hubo un error al cargar los horarios.');
                    });
            } else {
                tablaHorarios.style.display = 'none';
                btnMostrarModal.classList.add('d-none'); // Ocultar botón si falta algo
            }
        }


        // Escuchar cambios en los selects
        periodoSelect.addEventListener('change', cargarHorarios);
        docenteSelect.addEventListener('change', cargarHorarios);
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const docenteSelect = document.getElementById('id_docente');

        fetch(`/docentes/lista`)
            .then(res => res.json())
            .then(data => {
                docenteSelect.innerHTML = '<option value="">-- Seleccionar docente --</option>';
                data.forEach(docente => {
                    docenteSelect.innerHTML += `<option value="${docente.id}">${docente.nombre_completo}</option>`;
                });
            })
            .catch(error => {
                console.error('Error al cargar docentes:', error);
            });
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const btnMostrarModal = document.getElementById('btnMostrarModal');
        const inputPeriodoId = document.getElementById('inputPeriodoId');
        const inputDocenteId = document.getElementById('inputDocenteId');
        const inputPeriodoNombre = document.getElementById('inputPeriodoNombre');
        const inputDocenteNombre = document.getElementById('inputDocenteNombre');
        const selectPlan = document.getElementById('selectPlanEstudio');
        const selectCurso = document.getElementById('selectCurso');

        btnMostrarModal.addEventListener('click', () => {
            const selectPeriodo = document.getElementById('id_periodo');
            const selectDocente = document.getElementById('id_docente');

            const idPeriodo = selectPeriodo.value;
            const nombrePeriodo = selectPeriodo.options[selectPeriodo.selectedIndex].text;

            const idDocente = selectDocente.value;
            const nombreDocente = selectDocente.options[selectDocente.selectedIndex].text;

            inputPeriodoId.value = idPeriodo;
            inputPeriodoNombre.value = nombrePeriodo;

            inputDocenteId.value = idDocente;
            inputDocenteNombre.value = nombreDocente;

            // Cargar planes según el periodo seleccionado
            if (idPeriodo) {
                selectPlan.innerHTML = '<option value="">Cargando...</option>';
                fetch(`/planes/por-periodo/${idPeriodo}`)
                    .then(response => response.json())
                    .then(data => {
                        selectPlan.innerHTML = '<option value="">-- Seleccionar --</option>';
                        data.forEach(plan => {
                            const option = document.createElement('option');
                            option.value = plan.id;
                            option.textContent = plan.nombre;
                            selectPlan.appendChild(option);
                        });
                    })
                    .catch(error => {
                        console.error('Error al cargar los planes:', error);
                        selectPlan.innerHTML = '<option value="">Error al cargar</option>';
                    });
            }
        });

        // Cargar cursos según plan
        selectPlan.addEventListener('change', function () {
            const planId = this.value;
            selectCurso.innerHTML = '<option value="">Cargando...</option>';

            if (!planId) {
                selectCurso.innerHTML = '<option value="">-- Seleccionar --</option>';
                return;
            }

            fetch(`/cursos/por-plan/${planId}`)
                .then(response => response.json())
                .then(data => {
                    selectCurso.innerHTML = '<option value="">-- Seleccionar --</option>';
                    data.forEach(curso => {
                        const option = document.createElement('option');
                        option.value = curso.id;
                        option.textContent = curso.nombre;
                        selectCurso.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Error al cargar los cursos:', error);
                    selectCurso.innerHTML = '<option value="">Error al cargar</option>';
                });
        });
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {

        const formCrearHorario = document.getElementById('formCrearHorario');
        const modalCrearHorario = new bootstrap.Modal(document.getElementById('modalCrearHorario'));
        const tablaHorarios = document.getElementById('tabla-horarios').querySelector('tbody');

        formCrearHorario.addEventListener('submit', function (e) {
            e.preventDefault();

            // ==== CAMPOS OBLIGATORIOS ====
            const periodoId = document.getElementById('inputPeriodoId').value;
            const docenteId = document.getElementById('inputDocenteId').value;
            const planEstudio = document.getElementById('selectPlanEstudio').value;

            const cursoSelect = document.getElementById('selectCurso');
            const cursoId = cursoSelect.value;
            const nombreCurso = cursoSelect.options[cursoSelect.selectedIndex].text;

            const horaInicio = formCrearHorario.querySelector('[name="hora_inicio"]').value;
            const horaFin = formCrearHorario.querySelector('[name="hora_fin"]').value;
            const dia = formCrearHorario.querySelector('[name="dia"]').value;

            // ==== DATOS DE AULA ====
            const pabellonId = document.getElementById('selectPabellon').value;
            const aulaId = document.getElementById('selectAula').value;

            // datos auto-llenados por ajax
            const tipoAula = document.getElementById('info_tipo').value;
            const numeroAula = document.getElementById('info_numero').value;
            const capacidadAula = document.getElementById('info_capacidad').value;

            // ==== OTROS CAMPOS ====
            const frecuencia = formCrearHorario.querySelector('[name="frecuencia"]').value;
            const turno = formCrearHorario.querySelector('[name="id_turno"]').value;
            const seccion = formCrearHorario.querySelector('[name="id_seccion"]').value;

            // Validación
            if (!periodoId || !docenteId || !planEstudio || !cursoId ||
                !horaInicio || !horaFin || !dia || !pabellonId || !aulaId ||
                !tipoAula || !numeroAula || !capacidadAula || !frecuencia || !turno || !seccion) {

                Swal.fire({
                    icon: 'warning',
                    title: 'Campos incompletos',
                    text: 'Por favor complete todos los campos requeridos.'
                });
                return;
            }

            const formData = new FormData(this);

            // Asegurar que estos valores se envían
            formData.append('tipo_aula', tipoAula);
            formData.append('numero_aula', numeroAula);
            formData.append('capacidad', capacidadAula);
            formData.append('id_aula', aulaId);

            fetch(formCrearHorario.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(res => res.json())
            .then(data => {

                if (data.success) {
                    modalCrearHorario.hide();

                    Swal.fire({
                        icon: 'success',
                        title: 'Horario registrado',
                        text: data.message,
                        timer: 1800,
                        showConfirmButton: false
                    });

                    // Inserta nueva fila
                    const nuevaFila = document.createElement('tr');
                    nuevaFila.innerHTML = `
                        <td>${nombreCurso}</td>
                        <td>${data.horario.hora_inicio}</td>
                        <td>${data.horario.hora_fin}</td>
                        <td>${data.horario.dia}</td>
                        <td>${data.horario.numero_aula}</td>
                        <td>${data.horario.frecuencia}</td>
                    `;

                    tablaHorarios.appendChild(nuevaFila);

                    formCrearHorario.reset();
                    document.getElementById('selectCurso').innerHTML = '<option value="">-- Seleccionar --</option>';

                } else {

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data.message || 'No se pudo registrar el horario.'
                    });

                }

            })
            .catch(error => {
                console.error(error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error de servidor',
                    text: 'No se pudo guardar el horario. Intenta más tarde.'
                });
            });
        });

    });
</script>


<script>
    $('#selectPabellon').on('change', function () {
        let id = $(this).val();

        // Reset campos de información del aula
        $('#info_tipo').val('');
        $('#info_capacidad').val('');
        $('#info_numero').val('');
        $('#selectAula').html('<option value="">-- Seleccionar Aula --</option>');

        if (!id) {
            return;
        }

        $.ajax({
            url: "/pabellones/" + id + "/aulas",
            method: "GET",

            beforeSend: () => {
                $('#selectAula').html('<option>Cargando aulas...</option>');
            },

            success: function (res) {
                if (res.success) {
                    let options = '<option value="">-- Seleccionar Aula --</option>';

                    res.aulas.forEach(a => {
                        options += `
                            <option value="${a.id}">
                                ${a.nombre} (Nro: ${a.numero_aula})
                            </option>
                        `;
                    });

                    $('#selectAula').html(options);
                } else {
                    $('#selectAula').html('<option>No hay aulas registradas</option>');
                }
            },

            error: function () {
                $('#selectAula').html('<option>Error al cargar aulas</option>');
            }
        });
    });

    $('#selectAula').on('change', function () {
        let id = $(this).val();

        if (!id) {
            $('#info_tipo').val('');
            $('#info_capacidad').val('');
            $('#info_numero').val('');
            return;
        }

        $.ajax({
            url: "/aulas/" + id,
            method: "GET",

            success: function (res) {
                if (res.success) {
                    $('#info_tipo').val(res.data.tipo);
                    $('#info_capacidad').val(res.data.capacidad);
                    $('#info_numero').val(res.data.numero_aula);
                }
            },

            error: function () {
                Swal.fire("Error", "No se pudo cargar la información del aula", "error");
            }
        });
    });

</script>


@endsection
