<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Tramite Documentario <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Tramites <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoTramite">
                    <i class="fas fa-plus"></i> Agregar Nuevo Tramite
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Costo</th>
                                <th>Tiempo</th>
                                <th>Requisitos</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $tramites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tramite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($tramite->id); ?></td>
                                    <td><?php echo e($tramite->nombre); ?></td>
                                    <td><?php echo e($tramite->descripcion); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($tramite->estado == 'Activo' ? 'bg-success' : 'bg-secondary'); ?>">
                                            <?php echo e($tramite->estado); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($tramite->costo); ?></td>
                                    <td><?php echo e($tramite->tiempo); ?></td>
                                    <td>
                                        <?php if($tramite->requisitos->isEmpty()): ?>
                                            <span class="text-muted">Sin requisitos</span>
                                        <?php else: ?>
                                            <ul class="mb-0 ps-3">
                                                <?php $__currentLoopData = $tramite->requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($requisito->descripcion); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <!-- Botones de editar y eliminar -->
                                        <a href="#" class="text-warning me-2 btn-editar-tramite" data-id="<?php echo e($tramite->id); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <a href="#" class="text-danger btn-eliminar-tramite" data-id="<?php echo e($tramite->id); ?>">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal: Nuevo Requisito -->
<!-- Modal Nuevo Trámite -->
<div class="modal fade" id="modalNuevoTramite" tabindex="-1" aria-labelledby="modalNuevoTramiteLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formNuevoTramite">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Registrar Nuevo Trámite</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>

        <div class="modal-body">
          <?php echo csrf_field(); ?>
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="nombre" class="form-label">Nombre del Trámite</label>
              <input type="text" class="form-control" id="nombre" name="nombre" required>
            </div>

            <div class="col-md-6 mb-3">
              <label for="estado" class="form-label">Estado</label>
              <select class="form-select" id="estado" name="estado" required>
                <option value="Activo">Activo</option>
                <option value="Inactivo">Inactivo</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label for="costo" class="form-label">Costo</label>
              <input type="number" step="0.01" class="form-control" id="costo" name="costo">
            </div>

            <div class="col-md-6 mb-3">
              <label for="tiempo" class="form-label">Tiempo estimado</label>
              <input type="text" class="form-control" id="tiempo" name="tiempo" placeholder="Ej: 7 días hábiles">
            </div>

            <div class="col-12 mb-3">
              <label for="descripcion" class="form-label">Descripción</label>
              <textarea class="form-control" id="descripcion" name="descripcion" rows="3"></textarea>
            </div>

            <div class="col-12 mb-3">
              <label for="requisitos" class="form-label">Requisitos</label>
              <select class="form-select" name="requisitos[]" id="requisitos" multiple required style="height: 200px">
                <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($requisito->id); ?>"><?php echo e($requisito->descripcion); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>


<!-- Modal Editar Trámite -->
<div class="modal fade" id="modalEditarTramite" tabindex="-1" aria-labelledby="modalEditarTramiteLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="formEditarTramite">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Editar Trámite</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <?php echo csrf_field(); ?>
          <?php echo method_field('PUT'); ?>
          <input type="hidden" name="tramite_id" id="tramite_id">
          <div class="row">
            <div class="col-md-6 mb-3">
              <label for="edit_nombre" class="form-label">Nombre</label>
              <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
            </div>

            <div class="col-md-6 mb-3">
              <label for="edit_estado" class="form-label">Estado</label>
              <select class="form-select" id="edit_estado" name="estado" required>
                <option value="Activo">Activo</option>
                <option value="Inactivo">Inactivo</option>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label for="edit_costo" class="form-label">Costo</label>
              <input type="number" class="form-control" id="edit_costo" name="costo" step="0.01">
            </div>

            <div class="col-md-6 mb-3">
              <label for="edit_tiempo" class="form-label">Tiempo</label>
              <input type="text" class="form-control" id="edit_tiempo" name="tiempo">
            </div>

            <div class="col-12 mb-3">
              <label for="edit_descripcion" class="form-label">Descripción</label>
              <textarea class="form-control" id="edit_descripcion" name="descripcion" rows="3"></textarea>
            </div>

            <div class="col-12 mb-3">
              <label for="edit_requisitos" class="form-label">Requisitos</label>
              <select class="form-select" name="requisitos[]" id="edit_requisitos" multiple required>
                <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requisito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($requisito->id); ?>"><?php echo e($requisito->descripcion); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Actualizar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>







<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $('#modalNuevoTramite').on('shown.bs.modal', function () {
        $('#requisitos').select2({
            dropdownParent: $('#modalNuevoTramite'),
            width: '100%',
            placeholder: "Selecciona requisitos...",
            allowClear: true
        });
    });
    $('#formNuevoTramite').submit(function(e) {
        e.preventDefault();

        let form = $(this);
        let data = form.serialize();

        $.ajax({
            url: "<?php echo e(route('tramitess.store')); ?>",
            type: 'POST',
            data: data,
            success: function(response) {
                $('#modalNuevoTramite').modal('hide');
                Swal.fire('¡Éxito!', response.message, 'success');
                setTimeout(() => location.reload(), 1000);
            },
            error: function(xhr) {
                let errores = xhr.responseJSON.errors;
                let mensaje = errores ? Object.values(errores).join('<br>') : 'Error al registrar el trámite.';
                Swal.fire('Error', mensaje, 'error');
            }
        });
    });

</script>

<script>
$(document).ready(function () {

    // ===============================
    // ABRIR MODAL EDITAR
    // ===============================
    $(document).on('click', '.btn-editar-tramite', function (e) {
        e.preventDefault();

        const id = $(this).data('id');

        $.get('/tramitess/' + id, function (res) {

            const t = res.tramite;

            // 🔹 Campos
            $('#tramite_id').val(t.id);
            $('#edit_nombre').val(t.nombre);
            $('#edit_estado').val(t.estado);
            $('#edit_descripcion').val(t.descripcion ?? '');
            $('#edit_costo').val(t.costo ?? '');
            $('#edit_tiempo').val(t.tiempo ?? '');

            // 🔹 Reset requisitos
            $('#edit_requisitos option').prop('selected', false);

            // 🔹 Marcar requisitos existentes
            if (res.requisitos && res.requisitos.length > 0) {
                res.requisitos.forEach(function (reqId) {
                    $('#edit_requisitos option[value="' + reqId + '"]')
                        .prop('selected', true);
                });
            }

            $('#edit_requisitos').trigger('change');

            // 🔹 Abrir modal correcto
            $('#modalEditarTramite').modal('show');
        });
    });

    // ===============================
    // SUBMIT UPDATE
    // ===============================
    $('#formEditarTramite').on('submit', function (e) {
        e.preventDefault();

        const id = $('#tramite_id').val();
        const formData = $(this).serialize();

        $.ajax({
            url: '/tramitess/' + id,
            type: 'POST', // 🔥 POST + _method=PUT
            data: formData,
            success: function (response) {
                Swal.fire('Éxito', response.message, 'success')
                    .then(() => location.reload());
            },
            error: function (xhr) {

                if (!xhr.responseJSON || !xhr.responseJSON.errors) {
                    Swal.fire('Error', 'Error inesperado', 'error');
                    return;
                }

                let errors = xhr.responseJSON.errors;
                let msg = Object.values(errors)
                    .map(e => `• ${e[0]}`)
                    .join('<br>');

                Swal.fire('Errores de validación', msg, 'error');
            }
        });
    });

    // ===============================
    // SELECT2 EN MODAL
    // ===============================
    $('#edit_requisitos').select2({
        dropdownParent: $('#modalEditarTramite'),
        width: '100%',
        placeholder: 'Selecciona los requisitos',
        allowClear: true
    });

});
</script>

<script>
    $(document).ready(function () {
        $('.btn-eliminar-tramite').on('click', function (e) {
            e.preventDefault();
            const id = $(this).data('id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '/tramites/' + id,
                        type: 'DELETE',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function (response) {
                            Swal.fire('Eliminado', response.message, 'success').then(() => {
                                location.reload();
                            });
                        },
                        error: function (xhr) {
                            Swal.fire('Error', 'Ocurrió un problema al eliminar el trámite.', 'error');
                        }
                    });
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/tramitess/index.blade.php ENDPATH**/ ?>