<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    /**
     * Redirección después del login.
     */
    protected $redirectTo = RouteServiceProvider::HOME;



    /**
     * Constructor
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    /**
     * Usar 'username' en lugar de 'email' para autenticación
     */
    public function username()
    {
        return 'username';
    }

    /**
     * Sobrescribir el método login para usar 'password_hash' en la autenticación
     */
    protected function attemptLogin(Request $request)
    {
        return Auth::attempt([
            'username' => $request->username,
            'password' => $request->password
        ]);
        
    }

    /**
     * Personalizar la validación del login
     */
    protected function validateLogin(Request $request)
    {
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
        ]);
    }

    protected function authenticated(Request $request, $user)
    {
        return redirect()->route('dashboard'); // O la ruta que prefieras
    }
}
