<?php

namespace App\Http\Controllers;

use App\Models\Caja;
use App\Models\CajaHistorial;
use App\Models\TransaccionCaja;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CajaController extends Controller
{
    // Mostrar vista principal de caja
   public function index()
{
    // Obtener todas las cajas ordenadas por apertura descendente
    $cajas = Caja::orderBy('fecha_apertura', 'desc')->get();

    return view('caja.index', compact('cajas'));
}


    // Mostrar formulario de apertura
    public function apertura()
    {
        return view('caja.apertura');
    }

    // Guardar apertura
   public function abrir(Request $request)
{
    $request->validate([
        'apertura' => 'required|numeric|min:0',
        'nombre' => 'required|string|max:50',
        'observacion' => 'nullable|string',
    ]);

    DB::beginTransaction();

    try {
        $caja = Caja::create([
            'apertura' => $request->apertura,
            'saldo' => $request->apertura,
            'nombre' => $request->nombre,
            'observacion' => $request->observacion,
        ]);

        CajaHistorial::create([
            'caja_id' => $caja->id_caja,
            'tipo' => 'apertura',
            'monto' => $caja->apertura,
            'observacion' => 'Apertura de caja inicial',
        ]);

        DB::commit();

        return response()->json(['success' => true]);
    } catch (\Exception $e) {
        DB::rollBack();
        return response()->json([
            'success' => false,
            'message' => 'Error al abrir la caja: ' . $e->getMessage()
        ]);
    }
}



    // Mostrar formulario para cerrar
    public function cerrarForm($id)
    {
        $caja = Caja::findOrFail($id);
        return view('caja.cierre', compact('caja'));
    }

    // Guardar cierre
    public function cerrar(Request $request, $id)
{
    $caja = Caja::findOrFail($id);
    $caja->update([
        'fecha_cierre' => now(),
        'saldo_final' => $caja->saldo,
        'observacion' => 'Cierre automático por botón',
    ]);

    CajaHistorial::create([
        'caja_id' => $caja->id_caja,
        'tipo' => 'cierre',
        'monto' => $caja->saldo,
        'observacion' => 'Cierre automático por botón',
    ]);

    return response()->json(['success' => true, 'message' => 'Caja cerrada correctamente.']);
}



    // Ver historial
    public function historial()
    {
        $historial = CajaHistorial::with('caja')->orderBy('fecha', 'desc')->get();

        return view('caja.historial', compact('historial'));
    }

    // Ver transacciones por caja
    public function detalle($id)
{
    $transacciones = TransaccionCaja::where('caja_id', $id)->orderBy('fecha', 'desc')->get();
    $caja = Caja::findOrFail($id);

    return view('caja.partials.detalle', compact('transacciones', 'caja'));
}

}
