<?php

namespace App\Http\Controllers;

use App\Models\Empresa;
use Illuminate\Http\Request;

class EmpresaController extends Controller
{
    public function index()
    {
        $empresas = Empresa::all();
        return view('empresass.index', compact('empresas'));
    }

    public function create()
    {
        return view('empresass.create');
    }

    public function store(Request $request)
{
    $request->validate([
        'nombre_empresa' => 'required|string|max:255',
        'logo_empresa' => 'nullable|image|max:2048',
        'direccion_empresa' => 'required|string|max:255',
        'telefono_empresa' => 'required|string|max:15',
        'estado' => 'required|in:Activo,Inactivo',
    ]);

    $empresa = new Empresa();
    $empresa->nombre_empresa = $request->nombre_empresa;
    $empresa->direccion_empresa = $request->direccion_empresa;
    $empresa->telefono_empresa = $request->telefono_empresa;
    $empresa->estado = $request->estado;

    if ($request->hasFile('logo_empresa')) {
        $file = $request->file('logo_empresa');
        $nombreArchivo = time() . '_' . $file->getClientOriginalName();
        // Mover el archivo directamente a public/empresas
        $file->move(public_path('empresas'), $nombreArchivo);
        $empresa->logo_empresa = $nombreArchivo;
    }

    $empresa->save();

    return response()->json(['message' => 'Empresa creada con éxito']);
}


    public function edit(Empresa $empresa)
    {
        return view('empresas.edit', compact('empresa'));
    }

    public function update(Request $request, $id)
{
    $request->validate([
        'nombre_empresa' => 'required|string|max:255',
        'direccion_empresa' => 'required|string|max:255',
        'telefono_empresa' => 'required|string|max:15',
        'estado' => 'required|in:Activo,Inactivo',
        'logo_empresa' => 'nullable|image|max:2048',
    ]);

    $empresa = Empresa::findOrFail($id);
    $empresa->nombre_empresa = $request->nombre_empresa;
    $empresa->direccion_empresa = $request->direccion_empresa;
    $empresa->telefono_empresa = $request->telefono_empresa;
    $empresa->estado = $request->estado;

    if ($request->hasFile('logo_empresa')) {
        // Eliminar logo anterior si existe
        if ($empresa->logo_empresa && file_exists(public_path('empresas/' . $empresa->logo_empresa))) {
            unlink(public_path('empresas/' . $empresa->logo_empresa));
        }

        // Guardar nuevo logo
        $logo = $request->file('logo_empresa');
        $nombreLogo = uniqid('logo_') . '.' . $logo->getClientOriginalExtension();
        $logo->move(public_path('empresas'), $nombreLogo);
        $empresa->logo_empresa = $nombreLogo;
    }

    $empresa->save();

    return response()->json(['message' => 'Empresa actualizada con éxito']);
}



   public function destroy($id)
{
    $empresa = Empresa::findOrFail($id);

    // Opcional: eliminar logo si existe
    if ($empresa->logo_empresa && file_exists(public_path('empresas/' . $empresa->logo_empresa))) {
        unlink(public_path('empresas/' . $empresa->logo_empresa));
    }

    $empresa->delete();

    return response()->json(['message' => 'Empresa eliminada con éxito']);
}

}
