<?php

namespace App\Http\Controllers;

use App\Models\RequisitoTramite;
use Illuminate\Http\Request;

class RequisitoTramiteController extends Controller
{
    // Mostrar todos los requisitos
    public function index()
    {
        $requisitos = RequisitoTramite::all();
        return view('requisitos_tramite.index', compact('requisitos'));
    }

    // Mostrar el formulario para crear un nuevo requisito
    public function create()
    {
        return view('requisitos_tramite.create');
    }

    // Guardar un nuevo requisito
    public function store(Request $request)
{
    $request->validate([
        'descripcion' => 'required|string|max:255|unique:requisitos_tramite,descripcion',
        'estado' => 'in:Activo,Inactivo',
    ]);

    $requisito = RequisitoTramite::create([
        'descripcion' => $request->descripcion,
        'estado' => $request->estado ?? 'Activo',
    ]);

    // Si la petición es AJAX, retornamos JSON
    if ($request->ajax()) {
        return response()->json([
            'success' => true,
            'message' => 'Requisito creado correctamente.',
            'requisito' => $requisito
        ]);
    }

   
}


    // Mostrar formulario de edición
    public function edit($id)
    {
        $requisito = RequisitoTramite::findOrFail($id);
        return view('requisitos_tramite.edit', compact('requisito'));
    }

    // Actualizar un requisito
    public function update(Request $request, $id)
{
    $request->validate([
        'descripcion' => 'required|string|max:255|unique:requisitos_tramite,descripcion,' . $id,
        'estado' => 'in:Activo,Inactivo',
    ]);

    $requisito = RequisitoTramite::findOrFail($id);
    $requisito->update($request->all());

    if ($request->ajax()) {
        return response()->json([
            'success' => true,
            'message' => 'Requisito actualizado correctamente.'
        ]);
    }

    return redirect()->route('requisitos_tramite.index')->with('success', 'Requisito actualizado correctamente.');
}


    // Eliminar un requisito
    public function destroy($id)
{
    $requisito = RequisitoTramite::findOrFail($id);
    $requisito->delete();

    if (request()->ajax()) {
        return response()->json([
            'success' => true,
            'message' => 'Requisito eliminado correctamente.'
        ]);
    }

    return redirect()->route('requisitos_tramite.index')->with('success', 'Requisito eliminado correctamente.');
}

}
