<?php

namespace App\Imports;

use App\Models\Postulante;
use App\Models\PlanEstudio;
use App\Models\Admision;
use App\Models\ResultadoAdmision;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ResultadosMasivoImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {

            $postulante = Postulante::where('dni', trim($row['dni']))->first();
            if (!$postulante) continue;

            $plan = PlanEstudio::where('nombre', 'LIKE', '%' . trim($row['plan']) . '%')->first();
            if (!$plan) continue;

            $proceso = Admision::where('nombre', 'LIKE', '%' . trim($row['proceso']) . '%')->first();
            if (!$proceso) continue;

            $existe = ResultadoAdmision::where('postulante_id', $postulante->id_postulante)
                ->where('id_proceso', $proceso->id_admision)
                ->exists();

            if ($existe) continue;

            $estado = trim($row['estado']);
            $nota = floatval($row['nota']);

            ResultadoAdmision::create([
                'postulante_id'   => $postulante->id_postulante,
                'plan_estudio_id' => $plan->id,
                'id_proceso'      => $proceso->id_admision,
                'nota'            => $nota,
                'estado'          => $estado,
            ]);
        }
    }
}
