<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Admision extends Model
{
    protected $table = 'admisiones';
    protected $primaryKey = 'id_admision';
    public $timestamps = false;

    protected $fillable = [
        'id_periodo',
        'id_tipo_admision',
        'nombre',
        'inicio_proceso',
        'fin_proceso',
        'inicio_inscripciones',
        'fin_inscripciones',
        'inicio_extemporaneo',
        'fin_extemporaneo',
        'fecha_examen',
        'direccion',
        'activo'
    ];

    // Relaciones
    public function periodo()
    {
        return $this->belongsTo(Periodo::class, 'id_periodo');
    }

    public function tipoAdmision()
    {
        return $this->belongsTo(TipoAdmision::class, 'id_tipo_admision');
    }

    public function inscripciones()
    {
        return $this->hasMany(Inscripcion::class, 'id_admision');
    }

    public function resultados()
    {
        return $this->hasMany(ResultadoAdmision::class, 'id_proceso');
    }
    public function requisitos()
    {
        return $this->belongsToMany(Requisito::class, 'admisiones_requisitos', 'id_admision', 'id_requisito');
    }

    public function tiposPago()
    {
        return $this->belongsToMany(TipoPago::class, 'admisiones_tipo_pago', 'id_admision', 'id_tipo_pago');
    }
}
