<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Asistencia extends Model
{
    use HasFactory;

    protected $table = 'asistencias'; // Tu tabla en la base de datos

    protected $fillable = [
        'sesion_id',
        'matricula_curso_id',
        'fecha',
        'estado',
        'observaciones',
        'fecha_creacion',
    ];

    // app/Models/Asistencia.php

    public function sesion()
    {
        return $this->belongsTo(Sesion::class, 'sesion_id', 'id_sesion');
    }



    public function matriculaCurso()
    {
        return $this->belongsTo(MatriculaCurso::class, 'matricula_curso_id', 'id');
    }

}
