<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PagoPostulante extends Model
{
    protected $table = 'pagos_postulantes';
    protected $primaryKey = 'id_pagos';

    protected $fillable = [
        'postulante_id', 'concepto_id', 'caja_id',
        'monto', 'fecha', 'observacion', 'estado'
    ];

    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id', 'id_postulante');
    }

    public function concepto()
    {
        return $this->belongsTo(Concepto::class, 'concepto_id');
    }

    public function caja()
    {
        return $this->belongsTo(Caja::class, 'caja_id');
    }
}
