<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanEstudio extends Model
{
    use HasFactory;

    protected $table = 'planes_estudio';
    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id';
    protected $fillable = [
        'nombre',
        'descripcion',
        'activo',
        'codigo',
        'resolucion',
        'tipo','moodle_category_id',

    ];

    public function matriculas()
    {
        return $this->hasMany(Matricula::class);
    }

     // Relación con la tabla intermedia CursosPlanEstudio
     public function cursosPlanEstudios()
     {
         return $this->hasMany(CursosPlanEstudio::class, 'plan_estudio_id');
     }

    public function cursos()
    {
        return $this->belongsToMany(Curso::class, 'cursos_plan_estudio', 'plan_estudio_id', 'curso_id');
    }

    public function planesEstudioPeriodos()
    {
        return $this->hasMany(PlanesEstudioPeriodo::class);
    }

    // Relación muchos a muchos con Periodo
    public function periodos()
    {
        return $this->belongsToMany(Periodo::class, 'planes_estudio_periodos', 'plan_estudio_id', 'periodo_id');
    }

    // Relación con los módulos formativos
    public function modulosFormativos()
    {
        return $this->hasMany(ModuloFormativo::class, 'id_plan_estudio');
    }
}
