<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Provincia extends Model
{
    use HasFactory;

    protected $table = 'provincias';
    protected $primaryKey = 'idProv';
    public $timestamps = false;

    protected $fillable = ['Provincia', 'idDepa'];

    public function departamento()
    {
        return $this->belongsTo(Departamento::class, 'idDepa');
    }

    public function distritos()
    {
        return $this->hasMany(Distrito::class, 'idProv');
    }
}
