<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tarea extends Model
{
    protected $table = 'tareas';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'nombre',
        'descripcion',
        'subcomponente_id',
        'fecha',
        'fecha_fin',
        'hora_inicio',
        'hora_fin',
        'archivo',
        'sesion_id',
        'curso_id',
    ];

    protected $casts = [
        'fecha' => 'date',
        'fecha_fin' => 'date',
        'hora_inicio' => 'datetime:H:i',
        'hora_fin' => 'datetime:H:i',
    ];

    /* ===========================
       RELACIONES
    ============================*/

    // Cada tarea pertenece a un curso
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    // Cada tarea pertenece a un subcomponente
    public function subcomponente()
    {
        return $this->belongsTo(SubcomponenteLogro::class, 'subcomponente_id');
    }

    // Cada tarea pertenece a una sesión
    public function sesion()
    {
        return $this->belongsTo(Sesion::class, 'sesion_id', 'id_sesion'); 
        // Importante: llave primaria de sesiones es id_sesion
    }
}
