<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
{
    View::composer('*', function ($view) {
        if (Auth::check()) {
            $usuario = Auth::user();
            $modulosPermitidos = DB::table('modulo_roles')
                ->join('modulos', 'modulo_roles.modulo_id', '=', 'modulos.id')
                ->whereIn('rol_id', $usuario->roles->pluck('id')->toArray())
                ->pluck('modulos.nombre')
                ->toArray();

            $view->with('modulosPermitidos', $modulosPermitidos);
        }
    });
}
}
