<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class MoodleService
{
    protected $token;
    protected $url;

    public function __construct()
    {
        $this->token = "fd33e69868931504827618e6032e1966";
        $this->url   = "https://aulavirtual.iestpsannicolas.dedu.pe/webservice/rest/server.php";
    }

    private function send($function, $params = [])
    {
        $params['wstoken'] = $this->token;
        $params['wsfunction'] = $function;
        $params['moodlewsrestformat'] = 'json';

        return Http::asForm()->post($this->url, $params)->json();
    }

    // Crear una categoría
    public function crearCategoria($nombre, $descripcion = "", $parent = 0)
    {
        return $this->send("core_course_create_categories", [
            "categories" => [[
                "name"        => $nombre,
                "description" => $descripcion,
                "parent"      => $parent
            ]]
        ]);
    }

    // Crear un curso
    public function crearCurso($fullname, $shortname, $categoryId, $summary = "")
{
    return $this->send("core_course_create_courses", [
        "courses" => [[
            "fullname"  => $fullname,
            "shortname" => $shortname,   // debe ser único
            "categoryid" => $categoryId,
            "summary"   => $summary,
            "visible"   => 1,            // curso visible
            "format"    => "topics",     // formato estándar
        ]]
    ]);
}


public function crearUsuario($username, $password, $firstname, $lastname, $email)
{
    return $this->send("core_user_create_users", [
        "users" => [[
            "username"  => $username,
            "password"  => $password,
            "firstname" => $firstname,
            "lastname"  => $lastname,
            "email"     => $email,
            "auth"      => "manual",
        ]]
    ]);
}

public function matricularUsuario($moodleUserId, $moodleCourseId, $roleId = 5)
{
    return $this->send("enrol_manual_enrol_users", [
        "enrolments" => [[
            "roleid"   => $roleId,
            "userid"   => $moodleUserId,
            "courseid" => $moodleCourseId,
            "timestart" => time(),
            "timeend"   => 0
        ]]
    ]);
}

public function asignarProfesor($moodleUserId, $moodleCourseId)
{
    return $this->send("enrol_manual_enrol_users", [
        "enrolments" => [[
            "roleid"   => 3,           // Profesor con edición
            "userid"   => $moodleUserId,
            "courseid" => $moodleCourseId,
            "timestart" => time(),
            "timeend"   => 0
        ]]
    ]);
}
public function crearSeccion($courseId, $name, $sectionNum)
{
    return $this->send("core_course_create_sections", [
        "sections" => [[
            "courseid" => $courseId,
            "name"     => $name,
            "section"  => $sectionNum
        ]]
    ]);
}

// App\Services\MoodleService.php

// LISTAR EVALUACIONES DEL CURSO
public function obtenerEvaluacionesCurso(int $courseId)
{
    return $this->send('gradereport_user_get_grade_items', [
        'courseid' => $courseId
    ]);
}

// NOTAS DE UNA EVALUACIÓN (filtrada)
public function obtenerNotasEvaluacion(int $courseId, int $itemId)
{
    $response = $this->send('gradereport_user_get_grade_items', [
        'courseid' => $courseId
    ]);

    if (!isset($response['usergrades'])) {
        return $response;
    }

    foreach ($response['usergrades'] as &$user) {
        $user['gradeitems'] = array_values(array_filter(
            $user['gradeitems'],
            fn ($item) => $item['id'] == $itemId
        ));
    }

    return $response;
}




}
