<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Certificado de Estudios</title>
    <style>
        body {
            font-size: 14px;
            font-family: Arial, sans-serif;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        td, th {
            border: 1px solid black;
            padding: 4px;
            text-align: center;
        }
        th {
            background-color: #fff;
        }
        .header {
            text-align: center;
            margin: 20px 0;
        }
        .footer {
            text-align: right;
            margin-top: 30px;
        }
        .logo {
            max-width: 200px;
            height: auto;
        }
        .logo-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 20px;
        }
        .semestre-header {
            background-color: #f0f0f0;
        }
    </style>
</head>
<body>

    

    <h4 style="text-align: center;">CERTIFICADO DE ESTUDIOS DE EDUCACIÓN SUPERIOR TECNOLÓGICA</h4>

    <p>El que suscribe</p>
    <p><strong>{{ $nombre_instituto }}</strong></p>

    <div class="header">
        <h3>CERTIFICA</h3>
    </div>

    @php
        $alumno = $postulantes[0] ?? null;
    @endphp

    @if ($alumno)
        <p>Que, <strong>{{ $alumno->apellidos }} {{ $alumno->nombres }}</strong>, con código de alumno(a) N° <strong>{{ $alumno->dni }}</strong>, ha cursado las unidades didácticas que se indican en el programa de estudios de <strong>{{ $alumno->plan_estudio }}</strong>.</p>
        <p>El resultado final de las evaluaciones fue el siguiente:</p>
    @endif

    <table>
        <thead>
            <tr>
                <th rowspan="2">UNIDAD DIDÁCTICA</th>
                <th rowspan="2">CRÉDITOS</th>
                <th colspan="2">CALIFICATIVOS</th>
                <th rowspan="2">AÑO</th>
                <th rowspan="2">PER. ACAD.</th>
            </tr>
            <tr>
                <th>NÚMEROS</th>
                <th>LETRAS</th>
            </tr>
        </thead>
        <tbody>
            @php
                $semestre_actual = '';
            @endphp

            @forelse ($postulantes as $fila)
                @if ($semestre_actual !== $fila->semestre)
                    @php $semestre_actual = $fila->semestre; @endphp
                    <tr class="semestre-header">
                        <td colspan="6" style="text-align: left;"><strong>PERIODO {{ $semestre_actual }}</strong></td>
                    </tr>
                @endif
                <tr>
                    <td style="text-align: left;">{{ strtoupper($fila->curso) }}</td>
                    <td>{{ $fila->creditos }}</td>
                    <td>{{ $fila->nota_final ?? '-' }}</td>
                    <td>{{ $fila->nota_final_letras ?? '-' }}</td>
                    <td>{{ $fila->año }}</td>
                    <td>{{ $fila->periodo }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6">No se encontraron resultados.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <p>Así consta en los libros de actas de evaluaciones, a los que nos remitimos en caso sea necesario.</p>

    <div class="footer">
        <p>Apurímac, {{ \Carbon\Carbon::now()->format('d/m/Y') }}</p>
    </div>

    <div class="header">
        <h6>------------------------------------------------</h6>
        <h4>&nbsp;&nbsp;Director</h4>
    </div>

</body>
</html>
