@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Estudiante @endslot
@slot('title') Estudiantes @endslot
@endcomponent


<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header ">
               
                <a href="{{ route('estudiante.horario.pdf') }}" class="btn btn-primary" target="_blank">
                    <i class="fas fa-file-pdf"></i> Descargar PDF
                </a>
            </div>
            <div class="card-body">
                @if($mensaje)
                    <div class="alert alert-info">{{ $mensaje }}</div>
                @else
                    <div class="container">
                        <div class="row bg-light fw-bold text-center">
                            <div class="col-2">Hora</div>
                            @foreach($dias as $dia)
                                <div class="col-2">{{ $dia }}</div>
                            @endforeach
                        </div>

                        @foreach($horas as $inicio => $fin)
                        <div class="row border-bottom text-center py-2">
                            <div class="col-2 fw-bold">{{ $inicio }} - {{ $fin }}</div>
                            @foreach($dias as $dia)
                                <div class="col-2">
                                    @if(isset($horariosDias[$dia][$inicio]))
                                        <strong>{{ $horariosDias[$dia][$inicio]['curso'] }}</strong><br>
                                        Aula: {{ $horariosDias[$dia][$inicio]['aula'] }}
                                    @else
                                        &nbsp;
                                    @endif
                                </div>
                            @endforeach
                        </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>






@endsection
