@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Ver Estudiantes @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="card shadow rounded">
                    <div class="card-body">
                        {{-- Fila de Foto y Datos Personales --}}
                        <div class="row mb-4">
                            <div class="col-md-3 text-center">
                                @if($postulante->foto_postulante)
                                    <img src="{{ asset($postulante->foto_postulante) }}" alt="Foto del Estudiante" class="img-fluid rounded-circle border" width="150">
                                @else
                                    <img src="{{ asset('images/default-user.png') }}" alt="Sin foto" class="img-fluid rounded-circle border" width="150">
                                @endif
                            </div>

                            <div class="col-md-9">
                                <h4 class="fw-bold mb-2">{{ $postulante->nombres }} {{ $postulante->apellidos }}</h4>
                                <p><strong>DNI:</strong> {{ $postulante->dni }}</p>
                                <p><strong>Correo:</strong> {{ $postulante->email }}</p>
                                <p><strong>Teléfono:</strong> {{ $postulante->telefono }}</p>
                                <p><strong>Dirección:</strong> {{ $postulante->direccion }}</p>
                                <p><strong>Fecha de Nacimiento:</strong> {{ \Carbon\Carbon::parse($postulante->fecha_nacimiento)->format('d/m/Y') }}</p>
                            </div>
                        </div>

                        <hr>

                        {{-- Fila de Datos Académicos y Generales --}}
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <p><strong>Lengua Materna:</strong> {{ $postulante->lengua_materna }}</p>
                                <p><strong>Género:</strong> {{ $postulante->genero }}</p>
                                <p><strong>Grado:</strong> {{ $postulante->grado }}</p>
                                <p><strong>Año de Egreso:</strong> {{ $postulante->año_egreso }}</p>
                            </div>

                            <div class="col-md-6">
                                <p><strong>Discapacidad:</strong> 
                                    {{ $postulante->discapacidad ? 'Sí - ' . $postulante->nombre_discapacidad : 'No' }}
                                </p>
                                <p><strong>Fuente de Inscripción:</strong> {{ $postulante->fuente_inscripcion }}</p>
                                <p><strong>Registrado en:</strong> {{ \Carbon\Carbon::parse($postulante->fecha_registro)->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>

                        {{-- Sección de Documentos Adjuntos --}}
                        <div class="card mt-4">
                            <div class="card-header bg-primary text-white">
                                <i class="fas fa-folder-open"></i> Documentos Adjuntos
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    @if($postulante->certificado_estudios)
                                        <div class="col-md-6 mb-2">
                                            <a href="{{ asset($postulante->certificado_estudios) }}" target="_blank" class="btn btn-outline-primary w-100">
                                                <i class="fas fa-file-pdf"></i> Certificado de Estudios
                                            </a>
                                        </div>
                                    @endif

                                    @if($postulante->partida_nacimiento)
                                        <div class="col-md-6 mb-2">
                                            <a href="{{ asset($postulante->partida_nacimiento) }}" target="_blank" class="btn btn-outline-secondary w-100">
                                                <i class="fas fa-file-pdf"></i> Partida de Nacimiento
                                            </a>
                                        </div>
                                    @endif

                                    @if($postulante->comprobante_pago)
                                        <div class="col-md-6 mb-2">
                                            <a href="{{ asset($postulante->comprobante_pago) }}" target="_blank" class="btn btn-outline-success w-100">
                                                <i class="fas fa-file-invoice-dollar"></i> Comprobante de Pago
                                            </a>
                                        </div>
                                    @endif

                                    @if($postulante->copia_dni)
                                        <div class="col-md-6 mb-2">
                                            <a href="{{ asset($postulante->copia_dni) }}" target="_blank" class="btn btn-outline-dark w-100">
                                                <i class="fas fa-id-card"></i> Copia de DNI
                                            </a>
                                        </div>
                                    @endif

                                    @if($postulante->curriculum_archivo)
                                        <div class="col-md-6 mb-2">
                                            <a href="{{ asset($postulante->curriculum_archivo) }}" target="_blank" class="btn btn-outline-info w-100">
                                                <i class="fas fa-file-alt"></i> Curriculum Vitae
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        {{-- Botones inferiores --}}
                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('postulantess.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Volver
                            </a>
                        </div>
                    </div>
                </div>


                </div>
 
                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>










@endsection
