<table id="tablaSemestres" class="table table-striped mb-0 table-hover">
    <thead class="table-light">
        <tr>
            <th>#</th>
            <th>Fecha</th>
            <th>Concepto</th>
            <th>Monto</th>
            <th>Caja</th>
            <th>DNI</th>
            <th>Cliente</th>
        </tr>
    </thead>
    <tbody>
        @forelse($transacciones as $t)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $t->fecha }}</td>
                <td>{{ $t->concepto->nombre ?? '-' }}</td>
                <td>S/ {{ number_format($t->monto, 2) }}</td>
                <td>{{ $t->caja->nombre }}</td>
                <td>{{ $t->dni ?? '-' }}</td>
                <td>{{ $t->apellidos }} {{ $t->nombres }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="7" class="text-center text-muted">No se encontraron ingresos.</td>
            </tr>
        @endforelse
    </tbody>
    @if($transacciones->count())
        <tfoot>
            <tr>
                <th colspan="3">Total</th>
                <th colspan="4">S/ {{ number_format($total, 2) }}</th>
            </tr>
        </tfoot>
    @endif
</table>
