@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Roles @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoRol">
                    <i class="fas fa-plus"></i> Agregar Nuevo rol
                </button>
                <div class="table-responsive">
                    <table id="tablaRoles" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Descripción</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($roles as $role)
                                <tr>
                                    <td>{{ $role->id }}</td>
                                    <td>{{ $role->nombre }}</td>
                                    <td>{{ $role->descripcion }}</td>
                                    <td class="d-flex align-items-center gap-2">
                                        <div class="form-check form-switch m-0">
                                            <input class="form-check-input toggle-estado" 
                                                type="checkbox" 
                                                data-id="{{ $role->id }}" 
                                                {{ $role->estado ? 'checked' : '' }}>
                                        </div>
                                        <span class="estado-texto">
                                            {{ $role->estado ? 'Activo' : 'Inactivo' }}
                                        </span>
                                    </td>



                                    <td>
                                        <!-- Botón editar -->
                                        <a href="#"
                                            class="text-warning"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarRol"
                                            data-id="{{ $role->id }}"
                                            data-nombre="{{ $role->nombre }}"
                                            data-descripcion="{{ $role->descripcion }}"
                                            data-status="{{ $role->status }}">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <!-- Botón eliminar -->
                                        <form action="{{ route('roles.destroy', $role->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <!-- Botón de eliminación con AJAX -->
                                            <button type="button" class="btn btn-link p-0 m-0 align-baseline" id="deleteRole{{ $role->id }}" data-id="{{ $role->id }}">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>


                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->

<!-- Modal Nuevo Rol -->
<div class="modal fade" id="modalNuevoRol" tabindex="-1" aria-labelledby="nuevoRolLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="formNuevoRol">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="nuevoRolLabel">Nuevo Rol</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nombreRol" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombreRol" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="descripcionRol" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcionRol" name="descripcion" rows="3"></textarea>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="estadoRol" name="estado" checked>
                        <label class="form-check-label" for="estadoRol">Activo</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-de-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- Modal -->

<!-- Modal Editar Rol -->
<div class="modal fade" id="modalEditarRol" tabindex="-1" aria-labelledby="modalEditarRolLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarRol">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarRolLabel">Editar Rol</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="idRolEditar" name="id">

                    <div class="mb-3">
                        <label for="nombreRolEditar" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombreRolEditar" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="descripcionRolEditar" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcionRolEditar" name="descripcion"></textarea>
                    </div>

                    
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-de-primary">Actualizar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>





<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- tabla -->
<script>
    $(document).ready(function () {
        $("#tablaRoles").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaRoless_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- activar estado -->
<script>
    $(document).on('change', '.toggle-estado', function () {
        const $switch = $(this);
        const roleId = $switch.data('id');
        const nuevoEstado = $switch.is(':checked') ? 1 : 0;

        $.ajax({
            url: `/roles/${roleId}/estado`,
            type: 'POST',
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                estado: nuevoEstado
            },
            success: function (response) {
                // Actualiza el texto al lado del switch
                const texto = nuevoEstado ? 'Activo' : 'Inactivo';
                $switch.closest('td').find('.estado-texto').text(texto);

                Swal.fire({
                    icon: 'success',
                    title: 'Estado actualizado',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No se pudo actualizar el estado',
                    timer: 2000,
                    showConfirmButton: false
                });
            }
        });
    });


</script>

<!-- agregar -->
<script>
    $(document).ready(function () {
        $('#formNuevoRol').on('submit', function (e) {
            e.preventDefault();

            const formData = {
                nombre: $('#nombreRol').val(),
                descripcion: $('#descripcionRol').val(),
                estado: $('#estadoRol').is(':checked') ? 1 : 0,
                _token: $('meta[name="csrf-token"]').attr('content')
            };

            $.ajax({
                url: '{{ route("roles.store") }}',
                method: 'POST',
                data: formData,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Rol creado',
                        text: response.success,
                        showConfirmButton: true
                    }).then(() => {
                        $('#modalNuevoRol').modal('hide');
                        $('#formNuevoRol')[0].reset();
                        location.reload(); // O $('#tablaRoles').DataTable().ajax.reload();
                    });
                },
                error: function (xhr) {
                    let errorMsg = 'Error al guardar el rol';
                    if (xhr.responseJSON?.errors) {
                        const errores = Object.values(xhr.responseJSON.errors).flat().join('<br>');
                        errorMsg = errores;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: errorMsg,
                    });
                }
            });
        });
    });
</script>
<!-- editar -->
<script>
    // Rellenar campos al abrir modal
    $('#modalEditarRol').on('show.bs.modal', function (event) {
        const button = $(event.relatedTarget);
        const id = button.data('id');
        const nombre = button.data('nombre');
        const descripcion = button.data('descripcion');
        

        $('#idRolEditar').val(id);
        $('#nombreRolEditar').val(nombre);
        $('#descripcionRolEditar').val(descripcion);
        
    });

    // Enviar formulario de edición
    $('#formEditarRol').on('submit', function (e) {
        e.preventDefault();

        const id = $('#idRolEditar').val();
        const data = {
            nombre: $('#nombreRolEditar').val(),
            descripcion: $('#descripcionRolEditar').val(),
            estado: $('#estadoRolEditar').is(':checked') ? 1 : 0,
            _token: $('meta[name="csrf-token"]').attr('content'),
            _method: 'PUT'
        };

        $.ajax({
            url: `/roles/${id}`,
            method: 'POST',
            data: data,
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Rol actualizado',
                    text: response.success,
                    showConfirmButton: true
                }).then(() => {
                    $('#modalEditarRol').modal('hide');
                    $('#formEditarRol')[0].reset();
                    location.reload(); // O $('#tablaRoles').DataTable().ajax.reload();
                });
            },
            error: function (xhr) {
                let errorMsg = 'Error al actualizar el rol.';
                if (xhr.responseJSON?.errors) {
                    const errores = Object.values(xhr.responseJSON.errors).flat().join('<br>');
                    errorMsg = errores;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: errorMsg,
                });
            }
        });
    });
</script>

<script>
    $(document).on('click', '[id^="deleteRole"]', function () {
        const roleId = $(this).data('id');
        const csrfToken = $('meta[name="csrf-token"]').attr('content');

        Swal.fire({
            title: '¿Estás seguro?',
            text: 'Este rol se eliminará permanentemente.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#e3342f'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/roles/${roleId}`,
                    type: 'POST',
                    data: {
                        _token: csrfToken,
                        _method: 'DELETE'
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Eliminado',
                            text: response.success,
                            showConfirmButton: false,
                            timer: 2000
                        });

                        // Si usas DataTable
                        // $('#tablaRoles').DataTable().ajax.reload();

                        // O eliminar manualmente la fila
                        $(`#deleteRole${roleId}`).closest('tr').remove();
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'No se pudo eliminar el rol.',
                        });
                    }
                });
            }
        });
    });
</script>


@endsection
