<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Unidades Didacticas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <a href="<?php echo e(route('cursos.create')); ?>" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                    <i class="fas fa-plus"></i> Agregar Unidad Didáctica
                </a>


                <!-- Filtros -->
                <form id="filtroCursos" action="<?php echo e(route('cursos.index')); ?>" method="GET" class="mb-3">
                    <div class="row g-2 align-items-end">
                        <!-- Nombre del curso -->
                        <div class="col-md-3">
                            <label for="nombre" class="form-label">Nombre del Curso</label>
                            <input type="text" name="nombre" id="nombre" class="form-control form-control-sm" 
                                value="<?php echo e(request('nombre')); ?>" placeholder="Buscar por nombre">
                        </div>

                        <!-- Plan de Estudio -->
                        <div class="col-md-3">
                            <label for="plan_estudio_id" class="form-label">Plan de Estudio</label>
                            <select name="plan_estudio_id" id="plan_estudio_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" <?php echo e(request()->plan_estudio_id == $plan->id ? 'selected' : ''); ?>>
                                        <?php echo e($plan->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Semestre -->
                        <div class="col-md-2">
                            <label for="semestre_id" class="form-label">Semestre</label>
                            <select name="semestre_id" id="semestre_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($semestre->id); ?>" <?php echo e(request()->semestre_id == $semestre->id ? 'selected' : ''); ?>>
                                        <?php echo e($semestre->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Módulo -->
                        <div class="col-md-2">
                            <label for="modulo_id" class="form-label">Módulo Formativo</label>
                            <select name="modulo_id" id="modulo_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modulo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($modulo->id_modulo); ?>" <?php echo e(request()->modulo_id == $modulo->id_modulo ? 'selected' : ''); ?>>
                                        <?php echo e($modulo->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Botones -->
                        <div class="col-md-2 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-sm w-50">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                            <a href="<?php echo e(route('cursos.index')); ?>" class="btn btn-secondary btn-sm w-50">
                                <i class="fas fa-sync-alt"></i> Limpiar
                            </a>
                        </div>
                    </div>
                </form>



                <div class="table-responsive">
                
                <table id="tablaCursos" class="table table-striped mb-0 table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Tipo</th>
                            <th>Módulo</th>
                            <th>Plan de Estudio</th>
                            <th>Semestre</th>
                            <th>Créditos</th>
                            <th>Horas</th>
                            
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $cursos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $curso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($curso->id); ?></td>
                                <td><?php echo e($curso->nombre); ?></td>
                                <td><?php echo e($curso->tipo); ?></td>
                                <td><?php echo e($curso->modulo->nombre ?? 'Sin asignar'); ?></td>
                                <td>
                                    <?php $__currentLoopData = $curso->cursosPlanEstudios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-primary"><?php echo e($rel->planEstudio->nombre); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($curso->semestre->nombre ?? 'Sin asignar'); ?></td>
                                <td><?php echo e($curso->creditos); ?></td>
                                <td><?php echo e($curso->horas_semestrales); ?></td>
                               
                                <td>
                                    <!-- Editar -->
                                    <a href="<?php echo e(route('cursos.edit', $curso->id)); ?>" class="text-warning">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <!-- Eliminar -->
                                    <form action="<?php echo e(route('cursos.destroy', $curso->id)); ?>" method="POST" class="d-inline delete-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-link p-0" onclick="return confirm('¿Deseas eliminar este curso?')">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>







<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaCursos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaCursos_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    $(document).ready(function () {
        $('#filtroCursos').on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                url: $(this).attr('action'),
                method: 'GET',
                data: $(this).serialize(),
                success: function (response) {
                    $('#tablaCursos tbody').html(response); // ✅ Solo cambiamos las filas
                },
                error: function () {
                    alert('Ocurrió un error al filtrar los cursos.');
                }
            });
        });
    });
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpsannicolas.dedu.pe/resources/views/cursos/index.blade.php ENDPATH**/ ?>