
<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Requisitos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalRegistrarNota">
                    <i class="fas fa-plus"></i> Registrar Nota
                </button>
                <button type="button" class="btn btn-de-success btn-sm px-4 mt-0 mb-3"
                        data-bs-toggle="modal"
                        data-bs-target="#modalImportarExcel">
                    <i class="fas fa-file-excel"></i> Importación Masiva
                </button>

                 <div class="row mb-3">
                    <div class="col-md-4">
                        <label>Filtrar por Proceso</label>
                        <select id="filtroAdmision" class="form-select">
                            <option value="">-- Todos --</option>
                            <?php $__currentLoopData = \App\Models\Admision::orderBy('nombre')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($adm->id_admision); ?>"><?php echo e($adm->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Filtrar por Programa</label>
                        <select id="filtroPlan" class="form-select">
                            <option value="">-- Todos --</option>
                            <?php $__currentLoopData = \App\Models\PlanEstudio::orderBy('nombre')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="table-responsive">
                    
                     <table id="tablaResultados" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Postulante</th>
                                <th>DNI</th>
                                <th>Programa</th>
                                <th>Proceso</th>
                                <th>Nota</th>
                                <th>Estado</th>
                                <th>Opciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $resultados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-admision="<?php echo e($res->id_proceso); ?>" data-plan="<?php echo e($res->plan_estudio_id); ?>">
                                <td><?php echo e($res->id); ?></td>
                                <td><?php echo e($res->postulante->nombres); ?> <?php echo e($res->postulante->apellidos); ?></td>
                                <td><?php echo e($res->postulante->dni); ?></td>
                                <td><?php echo e($res->planEstudio->nombre ?? '-'); ?></td>
                                <td><?php echo e($res->admision->nombre ?? '-'); ?></td>
                                <td><strong><?php echo e($res->nota); ?></strong></td>
                                <td>
                                    <?php if($res->estado == 'Vacante'): ?>
                                        <span class="badge bg-success">Aprobado</span>

                                    <?php elseif($res->estado == 'Matriculado'): ?>
                                        <span class="badge bg-primary">Matriculado</span>

                                    <?php else: ?>
                                        <span class="badge bg-danger">Sin Vacante</span>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <button class="btn btn-warning btn-sm btnEditar"
                                            data-id="<?php echo e($res->id); ?>"
                                            data-nota="<?php echo e($res->nota); ?>">
                                        <i class="fas fa-edit"></i>
                                    </button>

                                    <button class="btn btn-danger btn-sm btnEliminar"
                                            data-id="<?php echo e($res->id); ?>">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->




<div class="modal fade" id="modalRegistrarNota" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formRegistrarNota">
            <?php echo csrf_field(); ?>

            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">Registrar Nota de Admisión</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        
                        <div class="col-md-6 mb-3">
                            <label><strong>Postulante</strong></label>
                            <select name="postulante_id" id="postulante_id"
                                class="form-select select2-modal" required>
                                <option value="">-- Seleccione --</option>
                                <?php $__currentLoopData = \App\Models\Postulante::orderBy('nombres')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($p->id_postulante); ?>">
                                        <?php echo e($p->dni); ?> — <?php echo e($p->apellidos); ?>, <?php echo e($p->nombres); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                        <div class="col-md-6 mb-3">
                            <label><strong>Programa / Plan de Estudio</strong></label>
                            <select name="plan_estudio_id" id="plan_estudio_id"
                                class="form-select select2-modal" required>
                                <option value="">-- Seleccione --</option>
                                <?php $__currentLoopData = \App\Models\PlanEstudio::orderBy('nombre')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                    </div>

                    <div class="row">

                        
                        <div class="col-md-6 mb-3">
                            <label><strong>Proceso de Admisión</strong></label>
                            <select name="id_proceso" id="id_proceso"
                                class="form-select select2-modal" required>
                                <option value="">-- Seleccione --</option>
                                <?php $__currentLoopData = \App\Models\Admision::orderBy('nombre')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($adm->id_admision); ?>"><?php echo e($adm->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                        <div class="col-md-6 mb-3">
                            <label><strong>Nota</strong></label>
                            <input type="number" min="0" max="20" step="0.01"
                                   name="nota" id="nota" class="form-control" required>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-1"></i> Guardar Nota
                    </button>
                </div>
            </div>

        </form>
    </div>
</div>




<div class="modal fade" id="modalEditarNota" tabindex="-1">
    <div class="modal-dialog">
        <form id="formEditarNota">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="modal-content">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title">Editar Nota</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="edit_id">

                    <label>Nota</label>
                    <input type="number" step="0.01" min="0" max="20" class="form-control" id="edit_nota">
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-warning">Actualizar</button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="modalImportarExcel" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formImportarExcel" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="modal-content">

                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-file-excel"></i> Importación Masiva de Resultados
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Subir Archivo Excel</label>
                            <input type="file" name="archivo" class="form-control" required>
                            <small class="text-muted">Formatos permitidos: .xlsx, .xls</small>
                        </div>

                        
                        <div class="col-md-6 mb-3">
                            <label class="fw-bold">Instrucciones</label>
                            <ul class="small">
                                <li>Descarga la plantilla modelo.</li>
                                <li>Completa los campos: <strong>DNI, Plan, Proceso, Nota, Estado</strong>.</li>
                                <li>El <strong>DNI</strong> se usa para buscar al postulante.</li>
                                <li>Plan y Proceso deben coincidir con los nombres registrados.</li>
                                <li>Estado: <strong>Vacante</strong> o <strong>Sin Vacante</strong>.</li>
                            </ul>

                            <a href="<?php echo e(asset('plantillas/plantilla_resultados.xlsx')); ?>"
                               class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-download"></i> Descargar Plantilla
                            </a>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload"></i> Importar Excel
                    </button>
                </div>

            </div>

        </form>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.8/js/select2.min.js" defer></script>


<script>
$(document).ready(function () {

    // ACTIVAR SELECT2 CUANDO EL MODAL SE ABRE
    $('#modalRegistrarNota').on('shown.bs.modal', function () {

        $('.select2-modal').select2({
            dropdownParent: $('#modalRegistrarNota'),
            width: '100%',
            placeholder: "-- Seleccione --",
            allowClear: true
        });

    });

    // REGISTRO DE NOTA POR AJAX
    $('#formRegistrarNota').submit(function (event) {
        event.preventDefault();

        let formData = new FormData(this);

        Swal.fire({
            title: 'Guardando...',
            text: 'Registrando la nota, por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "<?php echo e(route('resultados.store')); ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {

                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: 'Nota registrada correctamente.',
                    timer: 1500,
                    showConfirmButton: false
                });

                $('#modalRegistrarNota').modal('hide');

                setTimeout(() => location.reload(), 1200);
            },

            error: function (xhr) {

                Swal.close();

                if (xhr.status === 422) {

                    let mensaje = '';

                    // ✔ Errores de Laravel
                    if (xhr.responseJSON.errors) {
                        $.each(xhr.responseJSON.errors, function (key, value) {
                            mensaje += value[0] + '<br>';
                        });
                    }

                    // ✔ Mensaje directo (por ejemplo: duplicado)
                    if (xhr.responseJSON.message) {
                        mensaje += xhr.responseJSON.message + '<br>';
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores de validación',
                        html: mensaje
                    });

                } else {

                    Swal.fire({
                        icon: 'error',
                        title: 'Error inesperado',
                        text: 'Ocurrió un problema al registrar la nota.'
                    });

                }
            }
        });

    });

});
</script>





<script>
    $(document).ready(function () {
        $("#tablaResultados").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaResultados_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
$(document).ready(function () {

   

    // FILTRAR POR ADMISION
    $("#filtroAdmision").on('change', function() {
        let val = $(this).val();

        $("#tablaResultados tbody tr").each(function(){
            let row = $(this);
            if (val === "" || row.data("admision") == val) {
                row.show();
            } else {
                row.hide();
            }
        });
    });

    // FILTRAR POR PLAN
    $("#filtroPlan").on('change', function() {
        let val = $(this).val();

        $("#tablaResultados tbody tr").each(function(){
            let row = $(this);
            if (val === "" || row.data("plan") == val) {
                row.show();
            } else {
                row.hide();
            }
        });
    });


    // EDITAR NOTA
    $(".btnEditar").click(function () {
        let id = $(this).data("id");
        let nota = $(this).data("nota");

        $("#edit_id").val(id);
        $("#edit_nota").val(nota);

        $("#modalEditarNota").modal("show");
    });

    // ENVIAR FORMULARIO EDITAR NOTA
    $("#formEditarNota").submit(function (e) {
        e.preventDefault();

        let id = $("#edit_id").val();
        let nota = $("#edit_nota").val();

        $.ajax({
            url: "/resultados/" + id,
            method: "PUT",
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                nota: nota
            },
            success: function (res) {

                $("#modalEditarNota").modal("hide");

                Swal.fire({
                    icon: "success",
                    title: "Nota actualizada",
                    text: "La nota fue actualizada correctamente.",
                    confirmButtonColor: "#3085d6",
                }).then(() => {
                    location.reload();
                });

            },
            error: function (xhr) {
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: xhr.responseJSON?.message ?? "Ocurrió un error inesperado",
                    confirmButtonColor: "#d33",
                });
            }
        });
    });

    // ELIMINAR RESULTADO
    $(".btnEliminar").click(function () {
        let id = $(this).data("id");

        Swal.fire({
            title: "¿Estás seguro?",
            text: "Este resultado será eliminado permanentemente.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar"
        }).then((result) => {
            if (result.isConfirmed) {

                $.ajax({
                    url: "/resultados/" + id,
                    method: "DELETE",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (res) {
                        Swal.fire({
                            icon: "success",
                            title: "Eliminado",
                            text: "El resultado se eliminó correctamente.",
                            confirmButtonColor: "#3085d6",
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: xhr.responseJSON?.message ?? "No se pudo eliminar el resultado.",
                        });
                    }
                });

            }
        });
    });

    


});
</script>
<script>
$(document).ready(function () {

    $('#formImportarExcel').submit(function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        
        let formData = new FormData(this);

        Swal.fire({
            title: 'Importando...',
            text: 'Procesando archivo, por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "<?php echo e(route('resultados.importar')); ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {

                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Importación exitosa',
                    text: response.message,
                    timer: 1700,
                    showConfirmButton: false
                });

                $('#modalImportarExcel').modal('hide');

                // 🔥 reload limpio sin mostrar HTML de redirect
                setTimeout(() => {
                    window.location.href = "<?php echo e(route('resultados.index')); ?>";
                }, 1500);
            },

            error: function (xhr) {
                Swal.close();

                if (xhr.status === 422) {
                    let errores = xhr.responseJSON.errors ?? {};
                    let mensaje = "";

                    $.each(errores, function (key, value) {
                        mensaje += value[0] + "<br>";
                    });

                    if (xhr.responseJSON.message) {
                        mensaje += xhr.responseJSON.message;
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Errores en el archivo',
                        html: mensaje
                    });

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inesperado',
                        text: xhr.responseJSON?.message ?? 'No se pudo procesar el archivo.'
                    });
                }
            }
        });
    });
});

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/resultados/index.blade.php ENDPATH**/ ?>