<?php
    use Carbon\Carbon;
    $anioActual = Carbon::now()->year;
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 10px;
            color: #333;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 10px;
        }
        .header img {
            width: 300px;
        }
        .header h3 {
            margin: 10px 0;
            font-size: 16px;
        }
        .three-columns {
            width: 100%;
            display: block;
        }
        .column {
            width: 31.33%; /* Ajustar a 31.33% para que las tres columnas sumen 100% con margen */
            display: inline-block;
            vertical-align: top;
            margin-right: 1%; /* Margen del 1% */
            box-sizing: border-box;
        }
        .column:last-child {
            margin-right: 0; /* Eliminar margen en la última columna */
        }
        .column h4 {
            text-align: center;
            margin-bottom: 10px;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
            border: 1px solid #ddd;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: justify;
            word-wrap: break-word;
            overflow: hidden;
        }
        th {
            font-weight: bold;
            text-align: center;
        }
        .small-text {
            font-size: 11px;
        }

        /* Estilo personalizado para la tercera columna */
        .column h1 {
            font-size: 32px;
            text-align: center;
            border: 1px solid black;
            padding: 30px;
            margin: 30px 0;
        }

        .column h2 {
            font-size: 28px;
            text-align: center;
            border: 1px solid black;
            padding: 18px;
            margin: 30px 0;
        }

        .column h3 {
            font-size: 16px;
            margin-bottom: 30px;
        }

        /* Salto de página para nueva sección */
        .page-break {
            page-break-before: always;
        }

        .info-table, .notes-table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 20px;
            }
            .info-table td, .notes-table th, .notes-table td {
                border: 1px solid #ddd;
                padding: 12px;
               
            }
            .info-table th, .notes-table th {
                background-color: #f4f4f4;
                color: #333;
                font-weight: bold;
            }
            .info-table td {
                background-color: #fff;
            }
            .info-table .title {
                font-weight: bold;
                width: 30%;
                background-color: #f9f9f9;
                text-align: right;
                padding-right: 15px;
            }
            .info-table .value {
                width: 70%;
            }
            .notes-table td {
                text-align: center;
            }
            .notes-table .high-grade {
                color: black;
            }
            .notes-table .low-grade {
                color: red;
            }
            .total {
                font-weight: bold;
                text-align: right;
                background-color: #f4f4f4;
                padding-right: 12px;
            }
    </style>
</head>
<body>

    
    <div class="three-columns">

        
        <div class="column">
            <h4>Control de Asistencia</h4>
            <table>
                <thead>
                    <tr>
                        <th class="small-text">#</th>
                        <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="small-text"><?php echo e($index + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="small-text">Presentes</th>
                        <th class="small-text">Ausentes</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $contador = 1; ?>
                    <?php $__currentLoopData = $estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $asist = $asistencias[$e->matricula_curso_id] ?? [];
                            $pres = collect($asist)->where('estado', 'P')->count();
                            $aus = collect($asist)->where('estado', 'A')->count();
                        ?>
                        <tr>
                            <td><?php echo e($contador++); ?></td>
                            <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td><?php echo e($asist[$s->id_sesion]->estado ?? '-'); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($pres); ?></td>
                            <td><?php echo e($aus); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php for($i = $contador; $i <= 35; $i++): ?>
                        <tr>
                            <td><?php echo e($i); ?></td>
                            <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>-</td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td>0</td>
                            <td>0</td>
                        </tr>
                    <?php endfor; ?>
                </tbody>
            </table>
        </div>

        
        <div class="column">
            <h4>Indicadores de Logro</h4>
            <table>
                <tr><td colspan="2"><strong>Indicadores de Logro</strong></td></tr>
                <tr><th>Nº</th><th>Nombre</th></tr>
                <?php $__currentLoopData = $logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr><td><?php echo e($i+1); ?></td><td><?php echo e($logro->nombre); ?></td></tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
        </div>

        
        <div class="column">
            <div class="header">
                <?php if(file_exists($logoPath)): ?>
                    <img src="<?php echo e($logoPath); ?>" alt="Logo">
                <?php else: ?>
                    <p><strong><?php echo e($instituto->nombre); ?></strong></p>
                <?php endif; ?>
            </div>
            <h1>REGISTRO DE EVALUACIÓN Y NOTAS</h1>
            <h2><?php echo e($periodo->nombre ?? '---'); ?></h2>

            <h3>CARRERA PROFESIONAL: <?php echo e($curso->planesEstudio->first()->nombre ?? '---'); ?></h3>
            <h3>SEMESTRE: <?php echo e($curso->semestre->nombre ?? '---'); ?></h3>
            <h3>MÓDULO FORMATIVO: <?php echo e($curso->modulo->nombre ?? '---'); ?></h3>
            <h2>UNIDAD DIDÁCTICA</h2>
            <h2><?php echo e($curso->nombre); ?></h2>
            <h3>DOCENTE: <?php echo e($curso->docentes->first()->nombre_completo ?? '---'); ?></h3>
            <h3>PERIODO: <?php echo e($periodo->nombre ?? '---'); ?></h3>
        </div>

    </div>

    
    <div class="page-break">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Estudiante</th>
                    <?php $__currentLoopData = $lista_logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($logro); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th>Promedio</th>
                    <th>Recuperación</th>
                    <th>Nota Final</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $lista_estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $est): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $sum = 0; $count = 0;
                    ?>
                    <tr>
                        <td><?php echo e($i+1); ?></td>
                        <td><?php echo e($est['nombre']); ?></td>
                        <?php $__currentLoopData = $lista_logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $nota = $est['logros'][$logro] ?? '-';
                                $style = is_numeric($nota) && $nota < 11 ? 'color: red;' : '';
                                if (is_numeric($nota)) { $sum += $nota; $count++; }
                            ?>
                            <td style="<?php echo e($style); ?>"><?php echo e($nota); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $prom = $count ? round($sum / $count) : '-' ?>
                        <td><?php echo e($prom); ?></td>
                        <td></td>
                        <td><?php echo e($prom); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/reportes/acta_final.blade.php ENDPATH**/ ?>