<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Carátula del Curso</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
        .container { padding: 20px; }
        .details div { text-align: center; padding: 10px; margin-bottom: 10px; }
        .details h4 { margin: 0; padding: 10px; font-size: 20px; }
        .footer { margin-top: 40px; font-size: 12px; text-align: center; }
    </style>
</head>
<body>
    <?php if($instituto && $instituto->logo): ?>
        <div style="text-align: center;">
            <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" alt="Logo del Instituto" height="100">
        </div>
    <?php endif; ?>

    <div class="container">
        <div class="details">
            <div>
                <h4><?php echo e(strtoupper($instituto->nombre ?? 'INSTITUTO DE EDUCACIÓN SUPERIOR TECNOLÓGICO PÚBLICO')); ?></h4>
            </div>
            <div style="border: 1px solid black; margin: 0 100px;">
                <h1>REGISTRO ACADÉMICO</h1>
            </div>
            <div>
                <h2>PROGRAMA DE ESTUDIOS</h2>
                <p><?php echo e($curso->carrera); ?></p>
            </div>
            <div>
                <h2>MÓDULO FORMATIVO</h2>
                <p><?php echo e($curso->modulo); ?></p>
            </div>
            <div style="border: 1px solid black; margin: 0 100px;">
                <h2>UNIDAD DIDÁCTICA</h2>
                <p><?php echo e($curso->curso); ?></p>
            </div>
        </div>

        <p style="margin-left: 60px;"><strong>Horas Semestrales:</strong> <?php echo e($curso->horas_semestrales); ?></p>
        <p style="margin-left: 60px;"><strong>Créditos:</strong> <?php echo e($curso->creditos); ?></p>
        <p style="margin-left: 60px;"><strong>Semestre:</strong> <?php echo e($curso->semestre); ?></p>
        <p style="margin-left: 60px;"><strong>Docente:</strong> <?php echo e($curso->docente); ?> <?php echo e($curso->apellido); ?></p>

        <div class="footer">
            <p>............................................................</p>
            <h4><strong>Periodo:</strong> <?php echo e($curso->periodo); ?></h4>
        </div>
    </div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/caratulas/pdf.blade.php ENDPATH**/ ?>